% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNarrowPeak.R
\encoding{UTF-8}
\name{readNarrowPeakFile}
\alias{readNarrowPeakFile}
\title{Extract narrow regions and peaks from a narrrowPeak file}
\usage{
readNarrowPeakFile(file_path, extractRegions = TRUE, extractPeaks = TRUE)
}
\arguments{
\item{file_path}{the name of the file.}

\item{extractRegions}{a \code{logical} indicating if the narrow regions must
be extracted. If \code{TRUE}, a \code{GRanges} containing the
narrow regions will be returned. Otherwise, \code{NULL} is
returned. Default = \code{TRUE}.}

\item{extractPeaks}{a \code{logical} indicating if the peaks must
be extracted. If \code{TRUE}, a \code{GRanges} containing the peaks
will be returned. Otherwise, \code{NULL} is
returned. Default = \code{TRUE}.}
}
\value{
a \code{list} containing 2 entries:
\itemize{
\item narrowPeak a {\code{GRanges}} containing
the narrow regions extracted from the file. {\code{NULL}} when
not needed by user.
\item peak a {\code{GRanges}} containing
the peaks extracted from the file. {\code{NULL}} when not
}
}
\description{
Read a narrowPeak file and extract the narrow regions and/or
the peaks, as specified by used. The narrowPeak file must fit the
UCSC specifications. See
\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format12} for more
details. The file can have one or many header lines. However, the
total number of header lines must be inferior to 250 lines.
}
\examples{

## Set file information
test_narrowPeak <- system.file("extdata",
            "A549_FOSL2_ENCSR000BQO_MZW_part_chr_1_and_12.narrowPeak",
            package = "consensusSeekeR")

## Read file to extract peaks and regions
data <- readNarrowPeakFile(test_narrowPeak, extractRegions = TRUE,
            extractPeaks = TRUE)

## To access peak data (GRanges format)
head(data$peak)

## To access region data (GRanges format)
head(data$narrowPeak)

}
\author{
Astrid Deschênes
}
