% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_pct_var_exp_svd}
\alias{get_pct_var_exp_svd}
\title{Compute percent of variance explained}
\usage{
get_pct_var_exp_svd(thissvd, preproc_mat = thissvd$d)
}
\arguments{
\item{thissvd}{list outputted from an svd function (svd, irlba; can also take output from \code{\link{corral_mat}} and \code{\link{corralm_matlist}})}

\item{preproc_mat}{matrix of pre-processed values (optional) - important to include if the svd is only partial as this is used to compute the sum of eigenvalues}
}
\value{
vector of percent variance explained values, indexed by PC
}
\description{
Compute percent of variance explained
}
\examples{
mat <- matrix(sample(seq(0,20,1),100,replace = TRUE),nrow = 10)
my_svd <- svd(mat)
get_pct_var_exp_svd(my_svd) # this works if my_svd is a full svd
my_irl <- irlba::irlba(mat,nv = 2)
get_pct_var_exp_svd(my_irl, preproc_mat = mat) # ... otherwise use this 
}
