% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-functions.R
\name{kmeansProbaPost}
\alias{kmeansProbaPost}
\title{Calculate conditional probabilities of cluster membership for K-means clustering}
\usage{
kmeansProbaPost(clusters, tcounts)
}
\arguments{
\item{clusters}{Cluster labels arising from K-means clustering}

\item{tcounts}{Transformed counts clustered using K-means}
}
\value{
Conditional probabilities of cluster membership for each observation in each cluster
}
\description{
Calculate conditional probabilities of cluster membership for K-means clustering
}
\examples{
## Example of K-means taken from ?kmeans help page
x <- rbind(matrix(rnorm(100, sd = 0.3), ncol = 2),
           matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2))
           colnames(x) <- c("x", "y")
cl <- kmeans(x, 5)
probaPost <- kmeansProbaPost(cl$cluster, x)
head(probaPost)
}
