% Generated by roxygen2 (4.0.1): do not edit by hand
\name{assocPvalBySetPlot}
\alias{assocPvalBySetPlot}
\title{Create a Density Plot of P-Values, Highlighting SNPs
Within a Gene Set}
\usage{
assocPvalBySetPlot(pvals, set, title = "", geneSetColor = "red",
   xlab = expression(-log[10]~p-value), 
   ylab = "Density", 
   xlim = NULL, ylim = NULL,
  ...)
}
\arguments{
\item{pvals}{A numerical vector of p-values with names
corresponding to elements listed in the geneIds slot in the
set object.}

\item{set}{An object of class \code{GeneSet} where geneIds holds
the items of each set corresponding to the pvals.}

\item{title}{A character string containing the title of the plot.
Default is "", a blank title.}

\item{geneSetColor}{A character vector holding the color the
highlighted SNPs in the set object should be. Default is
\code{red}.}

\item{xlab}{A character vector with the label for the x-axis on
the plot. Default is \code{-log10(PValue)}.}

\item{ylab}{A character vector holding the label for the y-axis
on the plot. Default is \code{Density}.}

\item{xlim}{A vector of two numeric values with the limits of
plotting on the x-axis. By default, the range of the x-axis
values will be determined from the data.}

\item{ylim}{A vector with two numeric values used as limits for
plotting on the y-axis. By default, the range of the y-axis values
 will be determined from the data.}

\item{...}{Further arguments to be passed to the plotting methods,
such as graphical parameters.}
}
\value{
Creates a plot.
}
\description{
Plots association test p-values, highlighting p-values within
 gene sets.
}
\details{
Creates a density plot of all -log10(p-value), and overlaying
a density plot of -log10(p-value) for SNPs within a gene set
of interest.
}
\author{
Jason Hackney, Jessica Larson, Caitlin McHugh
\email{mchughc@uw.edu}
}

