% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsDesign.R
\name{validateOpsLibrary}
\alias{validateOpsLibrary}
\title{Validate gRNA library for optical pooled screening}
\usage{
validateOpsLibrary(
  df,
  min_dist_edit = 2,
  dist_method = c("hamming", "levenshtein")
)
}
\arguments{
\item{df}{data.frame containing information about candidate
gRNAs from which to build the OPS library. See details.}

\item{min_dist_edit}{Integer specifying the minimum distance edit
required for barcodes to be considered dissimilar.}

\item{dist_method}{String specifying distance method. Must be
either "hamming" (default) or "levenshtein".}
}
\value{
The original \code{df} is all checks pass.
    Otherwise, a stop error.
}
\description{
Validate gRNA library for optical pooled screening
}
\examples{
data(guideSetExample, package="crisprDesign")
guideSet <- unique(guideSetExample)
guideSet <- addOpsBarcodes(guideSet)
df <- data.frame(ID=names(guideSet),
                 spacer=spacers(guideSet, as.character=TRUE),
                 opsBarcode=as.character(guideSet$opsBarcode))
df$gene <- rep(paste0("gene",1:40),each=20)
df$rank <- rep(1:20,40)
opsLib <- designOpsLibrary(df)
opsLib <- validateOpsLibrary(opsLib)

}
\author{
Jean-Philippe Fortin
}
