% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotIndexesClust.R
\name{PlotIndexesClust}
\alias{PlotIndexesClust}
\title{Graphic visualization of an index}
\usage{
PlotIndexesClust(x, idx, k = NULL, scaling = TRUE)
}
\arguments{
\item{x}{list of expression data and their indexes after running
\code{\link{PreparingTheIndexes}}}

\item{idx}{A character, the index to plot
(e.g., for 8 time points "11100-1-1-1")}

\item{k}{A numeric, number of clusters. If not given the function will
calculate what is the optimal k for the index.}

\item{scaling}{A boolean, default to TRUE,
does the data should be standardized before clustered with K-means.}
}
\value{
A list with two objects:
 \enumerate{\item Table of of a specific index and its clusters
            \item Gene expression pattern graphs
            for each one of the clusters}
}
\description{
The function generates graphs and tables of a specific index and its
clusters. The user decides whether to supply the k or let the function
calculate the k for the selected index
}
\examples{

data_dir <- system.file("extdata", package = "ctsGE")
files <- dir(path=data_dir,pattern = "\\\\.xls$")
rts <- readTSGE(files, path = data_dir,
labels = c("0h","6h","12h","24h","48h","72h"), skip = 10625 )
prts <- PreparingTheIndexes(rts)
pp <- PlotIndexesClust(prts,idx="00101-1")
pp$graphs # plots the line graphs

}
\seealso{
\code{\link{ggplot}},  \code{\link{kmeans}},
 \code{\link{ClustIndexes}}
}

