% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_fcts.R
\name{queryAnnotDB}
\alias{queryAnnotDB}
\title{Annotation Queries with Compound IDs}
\usage{
queryAnnotDB(
  chembl_id,
  annot = c("drugAgeAnnot", "DrugBankAnnot", "cmapAnnot", "lincsAnnot")
)
}
\arguments{
\item{chembl_id}{character vector of ChEMBL IDs or compound ids from other 
annotation system..}

\item{annot}{character vector of annotation resources, such as
\code{drugAgeAnnot}, \code{DrugBankAnnot}, \code{cmapAnnot}, \code{lincsAnnot} 
or names of the annotation tables added by users. The \code{\link{listAnnot}}
function lists the available options for the \code{annot} argument names.}
}
\value{
data.frame of annotation result
}
\description{
This function can be used to query compound annotations from the default
resources as well as the custom resources stored in the SQLite annotation
database. The default annotation resources are DrugAge, DrugBank, CMAP02 and
LINCS. The customized compound annotations could be added/deleted by the
\code{\link{customAnnot}} utilities.
}
\details{
The input of this query function could be a set of ChEMBL IDs, it returns a
data.frame storing annotations of the input compounds from selected
annotation resources defined by the \code{annot} argument.

Since in the SQLite annotation database, ID identifiers from different ID systems, 
such as DrugBank and LINCS, are connected by ChEMBL IDs, it is hard to tell 
whether two IDs, such as DB00341, BRD-A42571354, refer to the same compound if 
either of them lack ID mappings to ChEMBL. So for querying compounds that don't 
have ChEMBL IDs, only one isolated database where the compounds belong to are 
supported. For example, a compound with LINCS id as "BRD-A00150179" doesn't have 
the ChEMBL ID mapping, when it is passed to the `chembl_id` argument, 
the `annot` need only to be set as `lincsAnnot` and the result
will be the compound annotation table from the LINCS annotation.
}
\examples{
query_id <- c("CHEMBL1000309", "CHEMBL100014", "CHEMBL100109",
               "CHEMBL100", "CHEMBL1000", "CHEMBL10")
qres <- queryAnnotDB(query_id, annot=c("drugAgeAnnot", "lincsAnnot"))

# Add a custom compound annotation table
chembl_id <- c("CHEMBL1000309", "CHEMBL100014", "CHEMBL10",
               "CHEMBL100", "CHEMBL1000", NA)
annot_tb <- data.frame(compound_name=paste0("name", 1:6),
        chembl_id=chembl_id,
        feature1=paste0("f", 1:6),
        feature2=rnorm(6))
addCustomAnnot(annot_tb, annot_name="myCustom2")

# query custom annotation
qres2 <- queryAnnotDB(query_id, annot=c("lincsAnnot", "myCustom2"))

# query compounds that don't have ChEMBL IDs
query_id <- c("BRD-A00474148", "BRD-A00150179", "BRD-A00763758", "BRD-A00267231")
qres3 <- queryAnnotDB(chembl_id=query_id, annot=c("lincsAnnot"))
qres3
}
