% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CytoK-class}
\alias{CytoK-class}
\title{the CytoK class}
\value{
\code{CytoKFeatures} returns the data.frame with shrunk
effect size, shrunk effect size sd, unadjusted p value and 
adjusted p value for each feature,
\code{CytoKFeaturesOrdered} returns the data.frame with shrunk
effect size, shrunk effect size sd, unadjusted p value and 
adjusted p value for each feature ordered by unadjusted p value
from low to high,
\code{CytoKDEfeatures} returns the percent of differentially
expressed features based on alpha (level of significance),
\code{CytoKData} returns the original data object,
\code{CytoKalpha} returns the specified level of
significance. Default is alpha=0.05.
\code{CytoKFeatureVars} returns the value of featureVars.
Default is NULL.
}
\description{
Objects of this class store
needed information to work with a
CytoK object
}
\section{Slots}{

\describe{
\item{\code{CytoKFeatures}}{CytoK features}

\item{\code{CytoKFeaturesOrdered}}{CytoK features ordered
by adjusted p values}

\item{\code{CytoKDEfeatures}}{Percent of Differentially Expressed
CytoK features}

\item{\code{CytoKData}}{Original data object passed to \code{CytoK}}

\item{\code{CytoKalpha}}{Value of \code{alpha} argument passed to \code{CytoK}}

\item{\code{CytoKFeatureVars}}{Value of \code{featureVars} passed
to \code{CytoK}. NULL if \code{featureVars} is left blank}
}}

\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)

}
