% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoviewer.R
\name{cytoviewer}
\alias{cytoviewer}
\title{cytoviewer - Shiny application to interactively browse multi-channel images}
\usage{
cytoviewer(
  image = NULL,
  mask = NULL,
  object = NULL,
  cell_id = NULL,
  img_id = NULL
)
}
\arguments{
\item{image}{(optional) a \code{CytoImageList} object containing 
single or multi-channel \code{Image} objects.}

\item{mask}{(optional) a \code{CytoImageList} containing
single-channel \code{Image} objects.}

\item{object}{(optional) a \code{SingleCellExperiment} or \code{SpatialExperiment} object.}

\item{cell_id}{character specifying the \code{colData(object)} entry, in which
the integer cell IDs are stored. These IDs should match the integer pixel
values in the segmentation mask object (\code{mask}).}

\item{img_id}{character specifying the \code{colData(object)} and
\code{mcols(mask)} and/or \code{mcols(image)} entry, 
in which the image IDs are stored.}
}
\value{
A Shiny app object for interactive multi-channel image visualization 
and exploration
}
\description{
This shiny R application allows users to interactively visualize multi-channel
images and segmentation masks generated by imaging mass cytometry and other
highly multiplexed imaging techniques. The \code{cytoviewer} interface is
divided into image-level (Composite and Channels) and cell-level visualization
(Masks). It allows users to overlay individual images with segmentation masks,
integrates well with \code{SingleCellExperiment} and \code{SpatialExperiment}
objects for metadata visualization and supports image downloads.
}
\section{The input objects}{


The functionality of \code{cytoviewer} depends on which input objects are
user-provided. Below we describe the four use cases in respect to input
objects and functionality.

\emph{1. Usage of cytoviewer with images, masks and object} 

The full functionality of cytoviewer can be leveraged when 
\code{image}, \code{mask} and \code{object} are provided. 
This allows image-level visualization (Composite and Channels), 
cell-level visualization, overlaying images with segmentation masks 
as well as metadata visualization. 

\emph{2. Usage of cytoviewer with images only }

If only \code{image} is specified, image-level visualization (Composite and
Channels) is possible.

\emph{3. Usage of cytoviewer with images and masks }

Image-level visualization (Composite and Channels), overlaying of images with
masks and cell-level visualization is feasible when \code{image} and
\code{mask} are provided.

\emph{4. Usage of cytoviewer with masks and object}

If \code{mask} and \code{object} are specified, cell-level visualization 
as well as metadata visualization is possible.
}

\examples{
# Load example datasets from cytomapper
library(cytomapper, quietly = TRUE)
data("pancreasImages")
data("pancreasMasks")
data("pancreasSCE")

# 1. Use cytoviewer with images, masks and object
app <- cytoviewer(image = pancreasImages, 
                  mask = pancreasMasks, 
                  object = pancreasSCE, 
                  img_id = "ImageNb", 
                  cell_id = "CellNb")
if (interactive()) {
shiny::runApp(app, launch.browser = TRUE)
}

## Other input variations (see "The input objects" section):

# 2. Use cytoviewer with images
app_1 <- cytoviewer(image = pancreasImages)
if (interactive()) {
shiny::runApp(app_1, launch.browser = TRUE)
}


# 3. Use cytoviewer with images and masks 
app_2 <- cytoviewer(image = pancreasImages, 
                  mask = pancreasMasks, 
                  img_id = "ImageNb")
if (interactive()) {
 shiny::runApp(app_2, launch.browser = TRUE)
}

# 4. Use cytoviewer with masks and object
app_3 <- cytoviewer(mask = pancreasMasks, 
                  object = pancreasSCE, 
                  img_id = "ImageNb", 
                  cell_id = "CellNb")
if (interactive()) {
 shiny::runApp(app_3, launch.browser = TRUE)
}

}
\seealso{
\code{\link[cytomapper]{plotPixels}} for the function underlying 
image-level visualization

\code{\link[cytomapper]{plotCells}} for the function underlying 
cell-level visualization

\code{\link[cytomapper]{cytomapperShiny}} for a shiny application that 
visualizes gated cells on images
}
\author{
Lasse Meyer (\email{lasse.meyer@dqbm.uzh.ch})
}
