% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{extract_unique_sample_ids}
\alias{extract_unique_sample_ids}
\title{Extract unique sample names from complex labels}
\usage{
extract_unique_sample_ids(
  sample_names,
  delimiter = "[-_\\\\.]",
  replicate_pattern = "^(n|N|r|rep|replicate|sample)\\\\d+"
)
}
\arguments{
\item{sample_names}{A character vector of sample labels.}

\item{delimiter}{A regular expression used as a delimiter to split labels
into blocks. (Default: `[-_\\.]`)}

\item{replicate_pattern}{A regular expression used to identify the
replicate block. (Default: `^(n|N|r|rep|replicate|sample)\\d+`)}
}
\value{
A vector of simplified, unique names. If a unique name cannot be
  formed or essential information is missing for a sample, the original
  label for that sample is returned as a fallback.
}
\description{
This function takes a vector of complex sample labels and iteratively
constructs a simplified, unique name for each. It identifies all blocks of
text that differ across the sample set and progressively adds them to a base
name until the combination of the base name and a replicate identifier is
unique for every sample.
}
\examples{
labels <- c(
  "RNAPII_elav-GSE77860-n1-SRR3164378-2017-vs-Dam.scaled.kde-norm",
  "RNAPII_elav-GSE77860-n2-SRR3164379-2017-vs-Dam.scaled.kde-norm",
  "RNAPII_elav-GSE77860-n4-SRR3164380-2017-vs-Dam.scaled.kde-norm",
  "RNAPII_Wor-GSE77860-n1-SRR3164346-2017-vs-Dam.scaled.kde-norm",
  "RNAPII_Wor-GSE77860-n2-SRR3164347-2017-vs-Dam.scaled.kde-norm",
  "RNAPII_Wor-GSE77860-sample1-SRR2038537-2017-vs-Dam.scaled.kde-norm"
)
extract_unique_sample_ids(labels)

}
