% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_normalisation.R
\name{quantile_normalisation}
\alias{quantile_normalisation}
\alias{quantile_normalization}
\title{Quantile normalisation (native R code version)}
\usage{
quantile_normalisation(x)
}
\arguments{
\item{x}{A numeric matrix; rows are features (e.g., genes), columns are samples/arrays.}
}
\value{
A numeric matrix of the same dimensions as \code{x}, quantile normalised.
}
\description{
Performs quantile normalisation of a numeric matrix in native R, matching
the algorithm used by `preprocessCore` (including its tie-handling rule).
}
\details{
This function is a native R implementation of the standard quantile
normalisation algorithm. It is designed to be a drop-in replacement for,
and produce identical results to, the function of the same name in the
`preprocessCore` package.

This native R version is provided within `damidBind` to avoid known
issues where the `preprocessCore` package can lead to errors or cause R to crash on some
Linux systems due to conflicts with OpenMP and/or BLAS/LAPACK library
configurations. By providing this native R implementation, `damidBind` ensures
it works reliably for all users without requiring them to recompile
dependencies or manage system environment variables.

This implementation exactly mirrors the behaviour of the `preprocessCore` library’s
classic quantile normalisation, including its specific handling of ties:
average ranks are computed for ties, and if the fractional part of a rank is greater than 0.4,
the output value is the average of the two adjacent quantile means; otherwise, only the lower
(floored) quantile mean is used.

The function stops if any NA, Inf, or NaN values are present in \code{x}.
}
\examples{
set.seed(1)
x <- matrix(rnorm(9), nrow = 3)
quantile_normalisation(x)

}
