% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefaction.R
\name{step_rarefaction}
\alias{step_rarefaction}
\alias{step_rarefaction,Recipe-method}
\alias{step_rarefaction,PrepRecipe-method}
\title{Resample an OTU table such that all samples have the same library size.}
\usage{
step_rarefaction(rec, id = rand_id("rarefaction"))

\S4method{step_rarefaction}{Recipe}(rec, id = rand_id("rarefaction"))

\S4method{step_rarefaction}{PrepRecipe}(rec, id = rand_id("rarefaction"))
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
Please note that the authors of phyloseq do not advocate using this as a
normalization procedure, despite its recent popularity. Our justifications
for using alternative approaches to address disparities in library sizes have
been made available as an article in PLoS Computational Biology. See
phyloseq_to_deseq2 for a recommended alternative to rarefying directly
supported in the phyloseq package, as well as the supplemental materials for
the PLoS-CB article and the phyloseq extensions repository on GitHub.
Nevertheless, for comparison and demonstration, the rarefying procedure is
implemented here in good faith and with options we hope are useful. This
function uses the standard R sample function to resample from the abundance
values in the otu_table component of the first argument, physeq. Often one of
the major goals of this procedure is to achieve parity in total number of
counts between samples, as an alternative to other formal normalization
procedures, which is why a single value for the sample.size is expected. This
kind of resampling can be performed with and without replacement, with
replacement being the more computationally-efficient, default setting. See
the replace parameter documentation for more details. We recommended that you
explicitly select a random number generator seed before invoking this
function, or, alternatively, that you explicitly provide a single positive
integer argument as rngseed.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- 
  recipe(metaHIV_phy, var_info = "RiskGroup2", tax_info = "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.03 * length(x))")

rec

## Define step with default parameters and prep
rec <- step_rarefaction(rec) 
  
rec
}
\concept{rarefaction phy steps}
