% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_pe.R
\name{permPvals}
\alias{permPvals}
\title{Exact permutation p-values}
\usage{
permPvals(nPermSupObs, nPermEff, totalPossibleNPerm)
}
\arguments{
\item{nPermSupObs}{number of permutations that yielded test statistics at
least as extreme as the observed data. Can be a vector or an array of values.}

\item{nPermEff}{number of permutations effectively computed.}

\item{totalPossibleNPerm}{total number of permutations possible.}
}
\value{
a vector (or an array, similar to \code{nperm_supobs})
of exact p-values
}
\description{
Calculates exact p-values for permutation tests when permutations are randomly
drawn with replacement. This implementation is based on
(slightly adapted) the implementation by Belinda Phipson and Gordon Smyth
from the R package \code{statmod}
}
\examples{
permPvals(10, 100, 1000)

}
\references{
Phipson B, and Smyth GK (2010). Permutation p-values should never
be zero: calculating exact p-values when permutations are randomly drawn.
\emph{Statistical Applications in Genetics and Molecular Biology}, Volume 9,
Issue 1, Article 39.
\url{http://www.statsci.org/smyth/pubs/PermPValuesPreprint.pdf}
}
\seealso{
statmod::permp
}
\author{
Belinda Phipson and Gordon Smyth (adapted by Boris Hejblum)
}
