% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_weights}
\alias{plot_weights}
\title{Plotting mean-variance fit for precision weights estimation}
\usage{
plot_weights(x)
}
\arguments{
\item{x}{a list (such as outputed by the functions 
\code{\link[dearseq]{sp_weights}} or \code{\link[dearseq]{voom_weights}}) 
containing the following components:\itemize{
\item \code{weights}: a matrix \code{n x G} containing the estimated precision 
weights 
\item \code{plot_utilities}: a list containing the following elements:\itemize{
     \item\code{reverse_trans}: a function encoding the reverse function used 
     for smoothing the observations before computing the weights
     \item\code{method}: the weight computation method (either \code{"voom"} 
     or \code{"loclin"})
     \item\code{smth}: the vector of the smoothed values computed 
     \item\code{gene_based}: a logical indicating whether the computed 
     weights are based on average at the gene level or on individual 
     observations
     \item\code{mu}: the transformed observed counts or averages
     \item\code{v}: the observed variability estimates
}
}}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Display the variability with respect to the level of expression and the 
associated smoothed estimation of precision weights accounting for 
heteroscedasticity.
}
\examples{
G <- 10000
n <- 12
p <- 2
y <- sapply(1:n, FUN = function(x){rnbinom(n = G, size = 0.07, mu = 200)})
x <- sapply(1:p, FUN = function(x){rnorm(n = n, mean = n, sd = 1)})

if(interactive()){
 w <- sp_weights(y, x, use_phi=FALSE, na.rm = TRUE, gene_based=TRUE)
 plot_weights(w)

 vw <-  voom_weights(y, x)
 plot_weights(vw)
}

}
\author{
Boris Hejblum
}
