% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_for_class_checks.R
\name{isSignatureSet}
\alias{isSignatureSet}
\title{isSignatureSet}
\usage{
isSignatureSet(x)
}
\arguments{
\item{x}{Object to be checked.}
}
\value{
Logical value (true or false).
}
\description{
`isSignatureSet()` checks whether the input object is a set (list) of
numeric objects compatible with either the Alexandrov format (probability
vectors; see \code{isAlexandrovSet}) or the Shiraishi format (matrices or
data.frames of probabilities; see \code{isShiraishiSet}).
NOTE: These can also be genomes compatible with one of the two formats!
}
\examples{

### get Alexandrov signatures from COSMIC
signAlexandrov <- readAlexandrovSignatures()

isSignatureSet(signAlexandrov)
}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{isAlexandrovSet}}\cr
\code{\link{isShiraishiSet}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
