% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAlexandrovSignatures.R
\name{readAlexandrovSignatures}
\alias{readAlexandrovSignatures}
\title{Read Alexandrov-type signatures (COSMIC format).}
\usage{
readAlexandrovSignatures(file)
}
\arguments{
\item{file}{(Mandatory) Can be a file name or an URL for download.
Default:\cr
"https://cancer.sanger.ac.uk/cancergenome/assets/signatures_probabilities.txt"
(COSMIC signatures v2).}
}
\value{
A list of Alexandrov signatures that can be used for
\code{decomposeTumorGenomes}.
}
\description{
`readAlexandrovSignatures()` reads a set of Alexandrov-type signatures
(COSMIC format) from a flat file or URL. Signatures must be specified in the
tab-separated format used by the COSMIC website for signatures version 2
(March 2015), the comma-separated format used for signatures version 3
(May 2019), the Microsoft Excel 2007+ sheet used for version 3.1, or the
tab-sperated format used for version 3.2 (see Details below). Excel sheets
cannot be read from an URL and must be downloaded first.
}
\details{
For details on the accepted signature formats, see below or\cr
\url{http://cancer.sanger.ac.uk/cosmic/signatures_v2} ->
"Download signatures" for version 2,\cr
\url{https://www.synapse.org/#!Synapse:syn12009743} for version 3,\cr
\url{https://cancer.sanger.ac.uk/sigs-assets-20/COSMIC_Mutational_Signatures_v3.1.xlsx}
for version 3.1, \cr
and \url{https://cancer.sanger.ac.uk/signatures/} for version 3.2. 
For versions 3, 3.1 and 3.2, only Single Base Substitution (SBS)
signatures can be used.

COSMIC format for Alexandrov signatures, version 2:

\tabular{llllll}{
Subst. \tab Trinucleotide \tab Mutation Type \tab Signature 1 \tab
Signature 2 \tab...\cr
C>A \tab ACA \tab A[C>A]A \tab 0.0110983262 \tab 0.0006827082 \tab...\cr
C>A \tab ACC \tab A[C>A]C \tab 0.0091493407 \tab 0.0006191072 \tab...\cr
C>A \tab ACG \tab A[C>A]G \tab 0.0014900705 \tab 0.0000992790 \tab...\cr
C>A \tab ACT \tab A[C>A]T \tab 0.0062338852 \tab 0.0003238914 \tab...\cr
[...]\cr
T>G \tab TTG \tab T[T>G]G \tab 0.0020310769 \tab 0.0002066152 \tab...\cr
T>G \tab TTT \tab T[T>G]T \tab 0.0040301281 \tab 0.0000235982 \tab...\cr
}

COSMIC/Synapse format for Alexandrov signatures, version 3 and 3.1:

\tabular{llllll}{
Type,SubType,SBS1,SBS2,SBS3,SBS4,SBS5,SBS6, ...\cr
C>A,ACA,8.86E-04,5.80E-07,2.08E-02,4.22E-02,1.20E-02,4.25E-04, ...\cr
C>A,ACC,2.28E-03,1.48E-04,1.65E-02,3.33E-02,9.44E-03,5.24E-04, ...\cr
C>A,ACG,1.77E-04,5.23E-05,1.75E-03,1.56E-02,1.85E-03,5.20E-05, ...\cr
C>A,ACT,1.28E-03,9.78E-05,1.22E-02,2.95E-02,6.61E-03,1.80E-04, ...\cr
[...]\cr
T>G,TTG,5.83E-04,9.54E-05,8.05E-03,2.32E-03,6.94E-03,3.24E-04, ...\cr
T>G,TTT,2.23E-16,2.23E-16,1.05E-02,5.68E-04,1.35E-02,1.01E-03, ...\cr
}

Version 3.1 has assentially the same format as version 3, but is distributed
as an Excel spread sheet.

COSMIC/Synapse format for Alexandrov signatures, version 3.2:

\tabular{llll}{
Type \tab SBS1 \tab SBS2 \tab...\cr
A[C>A]A \tab 0.0110983262 \tab 0.0006827082 \tab...\cr
A[C>A]C \tab 0.0091493407 \tab 0.0006191072 \tab...\cr
A[C>A]G \tab 0.0014900705 \tab 0.0000992790 \tab...\cr
A[C>A]T \tab 0.0062338852 \tab 0.0003238914 \tab...\cr
[...]\cr
T[T>G]G \tab 0.0020310769 \tab 0.0002066152 \tab...\cr
T[T>G]T \tab 0.0040301281 \tab 0.0000235982 \tab...\cr
}
}
\examples{

### get Alexandrov signatures from COSMIC
signatures <- readAlexandrovSignatures()

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{readShiraishiSignatures}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
