% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decontPro.R
\name{plotBoxByCluster}
\alias{plotBoxByCluster}
\title{Boxplot of features grouped by cell type}
\usage{
plotBoxByCluster(
  counts,
  decontaminated_counts,
  cell_type,
  features,
  file = NULL
)
}
\arguments{
\item{counts}{original count matrix of nADT x nDroplet.}

\item{decontaminated_counts}{decontaminated count matrix.}

\item{cell_type}{1xnDroplet vector of cell_type.}

\item{features}{names of ADT to plot}

\item{file}{file name to save plot into a pdf. If omit, return \code{ggplot}
object.}
}
\value{
Return a pdf file named \code{file} or a \code{ggplot} object.
}
\description{
Boxplot of features grouped by cell type
}
\examples{
# Simulate a dataset with 3 cells and 2 ADTs
counts <- matrix(c(60, 72, 52, 49, 89, 112),
                 nrow = 2,
                 dimnames = list(c('CD3', 'CD4'),
                                 c('CTGTTTACACCGCTAG',
                                   'CTCTACGGTGTGGCTC',
                                   'AGCAGCCAGGCTCATT')))

decontaminated_counts <- matrix(c(58, 36, 26, 45, 88, 110),
                                nrow = 2,
                                dimnames = list(c('CD3', 'CD4'),
                                                c('CTGTTTACACCGCTAG',
                                                  'CTCTACGGTGTGGCTC',
                                                  'AGCAGCCAGGCTCATT')))

plotBoxByCluster(counts,
                 decontaminated_counts,
                 c(1, 2, 1),
                 c('CD3', 'CD4'))
}
