% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decontx.R
\name{plotDecontXContamination}
\alias{plotDecontXContamination}
\title{Plots contamination on UMAP coordinates}
\usage{
plotDecontXContamination(
  x,
  batch = NULL,
  colorScale = c("blue", "green", "yellow", "orange", "red"),
  size = 1
)
}
\arguments{
\item{x}{Either a \linkS4class{SingleCellExperiment} with \code{decontX}
results stored in \code{metadata(x)$decontX} or the result from running
decontX on a count matrix.}

\item{batch}{Character. Batch of cells to plot. If \code{NULL}, then
the first batch in the list will be selected. Default \code{NULL}.}

\item{colorScale}{Character vector. Contains the color spectrum to be passed
to \code{scale_colour_gradientn} from package 'ggplot2'. Default
c("blue","green","yellow","orange","red").}

\item{size}{Numeric. Size of points in the scatterplot. Default 1.}
}
\value{
Returns a \code{ggplot} object.
}
\description{
A scatter plot of the UMAP dimensions generated by DecontX with
cells colored by the estimated percentation of contamation.
}
\examples{
# Generate matrix with contamination
s <- simulateContamination(seed = 12345)

library(SingleCellExperiment)
library(celda)
sce <- SingleCellExperiment(list(counts = s$observedCounts))
sce <- decontX(sce)

# Plot contamination on UMAP
plotDecontXContamination(sce)

# Plot decontX cluster labels
umap <- reducedDim(sce)
celda::plotDimReduceCluster(x = sce$decontX_clusters,
    dim1 = umap[, 1], dim2 = umap[, 2], )

# Plot percentage of marker genes detected
# in each cell cluster before decontamination
s$markers
plotDecontXMarkerPercentage(sce, markers = s$markers, assayName = "counts")

# Plot percentage of marker genes detected
# in each cell cluster after contamination
plotDecontXMarkerPercentage(sce, markers = s$markers,
                            assayName = "decontXcounts")

# Plot percentage of marker genes detected in each cell
# comparing original and decontaminated counts side-by-side
plotDecontXMarkerPercentage(sce, markers = s$markers,
                            assayName = c("counts", "decontXcounts"))

# Plot raw counts of indiviual markers genes before
# and after decontamination
plotDecontXMarkerExpression(sce, unlist(s$markers))
}
\seealso{
See \code{\link{decontX}} for a full example of how to estimate
and plot contamination.
}
\author{
Shiyi Yang, Joshua Campbell
}
