% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findSignatures.R
\name{findSignatures}
\alias{findSignatures}
\title{A function to construct a signature matrix}
\usage{
findSignatures(
  samples,
  sampleMeta,
  atlas = NULL,
  variation_cutoff = NULL,
  K = 100,
  IDs = NULL,
  tissueSpecCpGs = FALSE,
  tissueSpecDMPs = FALSE
)
}
\arguments{
\item{samples}{dataframe, has first column IDs, rest of columns are samples
(must have column name as sample accession ID which should be found in
sampleMeta), rows are units of signature (e.g. CpGs)}

\item{sampleMeta}{dataframe, must have first column for accession ID of each
sample, and second column for cell type of sample, rows are samples}

\item{atlas}{dataframe, the reference atlas to which new signatures can be
added, if not present then a new reference atlas will be created using
sample(s). Should be dataframe with column for each cell type, rows units of
signature (e.g. CpGs)}

\item{variation_cutoff}{either a number between 0 to 1, or NULL.For multiple
samples from the same cell type, ignore CpGs with variation >
variation_cutoff with that cell type. defaults to NULL (i.e. no cutoff)}

\item{K}{only valid when tissueSpecCpGs is TRUE. K is the number of top
methylation signature to be extracted.}

\item{IDs}{the name of the column indicates ids}

\item{tissueSpecCpGs}{if TRUE and atlas provided, it will extract tissue
specific CpGs.}

\item{tissueSpecDMPs}{if TRUE and atlas provided, it will extract tissue
specific DMPs. Note that both tissueSpecCpGs and tissueSpecDMPs can't be
TRUE at the same time.}
}
\value{
A dataframe extendedAtlas which contains all cell types in atlas
(if given), and those in samples added by cell type, has first column "IDs",
rest of columns are cell types, rows are have first cell with the ID
(e.g. CpG ID) and then values of signature (e.g. methylation values)
If tissueSpecCpGs is TRUE, it will return a list of list containing tissue
specific methylation signatures.
If tissueSpecDMPs is TRUE, it will return a list containing tissue specific
DMPs.
}
\description{
A function to construct a signature matrix
}
\examples{
data("HumanCellTypeMethAtlas")
exampleSamples <- simulateCellMix(1,
  reference = HumanCellTypeMethAtlas
)$simulated
exampleMeta <- data.table(
  "Experiment_accession" = "example_sample",
  "Biosample_term_name" = "example_cell_type"
)
colnames(exampleSamples) <- c("CpGs", "example_sample")
colnames(HumanCellTypeMethAtlas)[1] <- c("CpGs")

signatures <- findSignatures(
  samples = exampleSamples,
  sampleMeta = exampleMeta,
  atlas = HumanCellTypeMethAtlas,
  IDs = "CpGs", tissueSpecCpGs = FALSE
)
signatures <- findSignatures(
  samples = exampleSamples,
  sampleMeta = exampleMeta,
  atlas = HumanCellTypeMethAtlas,
  IDs = "CpGs", K = 100, tissueSpecCpGs = TRUE
)
}
