% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaCaptureC.R
\name{getPValueCutoff}
\alias{getPValueCutoff}
\title{This function returns the significance levels for min, max, "abs"
and lopsidedness.}
\usage{
getPValueCutoff(runStats, p = 0.05)
}
\arguments{
\item{runStats}{a matrix with columns 'min','max','abs' and
'lopsidededness'}

\item{p}{=.05 the desired p-value}
}
\value{
a vector with cutoff values
}
\description{
Given an Nx4 matrix with columns 'min','max','abs' and
'lopsidededness', this function returns the cutoff levels for a given
pValue.
}
\examples{
dimnames = list(c(),c('min','max','abs','lopsidedness'))
m = 10 * (matrix(runif(400),ncol=4,dimnames=dimnames) - 0.5)
cutoffs = getPValueCutoff(m,.05)
}
