% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStats.R
\name{calculateStats}
\alias{calculateStats}
\title{Calculate F-statistics at base pair resolution from a loaded BAM files}
\usage{
calculateStats(coveragePrep, models, lowMemDir = NULL, ...)
}
\arguments{
\item{coveragePrep}{A list with \verb{$coverageProcessed},
\verb{$mclapplyIndex}, and \verb{$position} normally generated using
\link{preprocessCoverage}.}

\item{models}{A list with \verb{$mod} and \verb{$mod0} normally generated
using \link{makeModels}.}

\item{lowMemDir}{The directory where the processed chunks are saved when
using \link{preprocessCoverage} with a specified \code{lowMemDir}.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{verbose }{ If \code{TRUE} basic status updates will be printed along
the way.}
\item{scalefac }{ This argument is passed to
\link[derfinderHelper:fstats.apply]{fstats.apply} and should be the same as the one used
in \link{preprocessCoverage}. Default: 32.}
\item{method }{ Has to be either 'Matrix' (default), 'Rle' or 'regular'. See
details in \link[derfinderHelper:fstats.apply]{fstats.apply}.}
\item{adjustF }{ A single value to adjust that is added in the denominator
of the F-stat calculation. Useful when the Residual Sum of Squares of the
alternative model is very small. Default: 0.}
}
Passed to \link{define_cluster}.}
}
\value{
A numeric Rle with the F-statistics per base pair that passed the
cutoff.
}
\description{
After defining the models of interest (see \link{makeModels}) and
pre-processing the data (see \link{preprocessCoverage}), use
\link{calculateStats} to calculate the F-statistics at base-pair resolution.
}
\examples{
## Collapse the coverage information
collapsedFull <- collapseFullCoverage(list(genomeData$coverage),
    verbose = TRUE
)

## Calculate library size adjustments
sampleDepths <- sampleDepth(collapsedFull, probs = c(0.5), verbose = TRUE)

## Build the models
group <- genomeInfo$pop
adjustvars <- data.frame(genomeInfo$gender)
models <- makeModels(sampleDepths, testvars = group, adjustvars = adjustvars)

## Preprocess the data
prep <- preprocessCoverage(genomeData,
    cutoff = 0, scalefac = 32,
    chunksize = 1e3, colsubset = NULL
)

## Run the function
fstats <- calculateStats(prep, models, verbose = TRUE, method = "regular")
fstats
\dontrun{
## Compare vs pre-packaged F-statistics
library("testthat")
expect_that(fstats, is_equivalent_to(genomeFstats))
}

}
\seealso{
\link{makeModels}, \link{preprocessCoverage}
}
\author{
Leonardo Collado-Torres
}
