% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRegionCoverage.R
\name{getRegionCoverage}
\alias{getRegionCoverage}
\title{Extract coverage information for a set of regions}
\usage{
getRegionCoverage(
  fullCov = NULL,
  regions,
  totalMapped = NULL,
  targetSize = 8e+07,
  files = NULL,
  ...
)
}
\arguments{
\item{fullCov}{A list where each element is the result from
\link{loadCoverage} used with \code{returnCoverage = TRUE}. Can be generated
using \link{fullCoverage}. Alternatively, specify \code{files} to extract
the coverage information from the regions of interest. This can be
helpful if you do not wish to store \code{fullCov} for memory reasons.}

\item{regions}{The \verb{$regions} output from \link{calculatePvalues}. It
is important that the seqlengths information is provided.}

\item{totalMapped}{The total number of reads mapped for each sample.
Providing this data adjusts the coverage to reads in \code{targetSize}
library. By default, to reads per 80 million reads.}

\item{targetSize}{The target library size to adjust the coverage to. Used
only when \code{totalMapped} is specified.}

\item{files}{A character vector with the full path to the sample BAM files
(or BigWig files).
The names are used for the column names of the DataFrame. Check
\link{rawFiles} for constructing \code{files}. \code{files} can also be a
\code{BamFileList} object created with \link[Rsamtools:BamFile-class]{BamFileList} or a
\code{BigWigFileList} object created with \link[rtracklayer:BigWigFile]{BigWigFileList}.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{verbose }{ If \code{TRUE} basic status updates will be printed along
the way.}
}
Passed to \link{extendedMapSeqlevels} and \link{define_cluster}.

When \code{fullCov} is \code{NULL}, \code{...} has the advanced argument
\code{protectWhich} (default 30000) from \link{loadCoverage}. Also
\code{...} is passed to \link{fullCoverage} for loading the data on the fly.
This can be useful for loading the data from a specific region (or small
sets of regions) without having to load in memory the output the coverage
information from all the genome.}
}
\value{
a list of data.frame where each data.frame has the coverage
information (nrow = width of region, ncol = number of samples) for a given
region. The names of the list correspond to the region indexes in
\code{regions}
}
\description{
This function extracts the raw coverage information calculated by
\link{fullCoverage} at each base for a set of regions found with
\link{calculatePvalues}. It can further calculate the mean coverage per
sample for each region.
}
\details{
When \code{fullCov} is the output of \link{loadCoverage} with
\code{cutoff} non-NULL, \link{getRegionCoverage} assumes that the regions
come from the same data. Meaning that \link{filterData} was not used again.
This ensures that the regions are a subset of the data available in
\code{fullCov}.

If \code{fullCov} is \code{NULL} and \code{files} is specified, this function
will attempt to read the coverage from the files. Note that if you used
'totalMapped' and 'targetSize' before, you will have to specify them again
to get the same results.

You should use at most one core per chromosome.
}
\examples{
## Obtain fullCov object
fullCov <- list("21" = genomeDataRaw$coverage)

## Assign chr lengths using hg19 information, use only first two regions
library("GenomeInfoDb")  # for getChromInfoFromUCSC()
regions <- genomeRegions$regions[1:2]
seqlengths(regions) <- seqlengths(getChromInfoFromUCSC("hg19",
    as.Seqinfo = TRUE
))[
    mapSeqlevels(names(seqlengths(regions)), "UCSC")
]

## Finally, get the region coverage
regionCov <- getRegionCoverage(fullCov = fullCov, regions = regions)
}
\seealso{
\link{fullCoverage}, \link{calculatePvalues}
}
\author{
Andrew Jaffe, Leonardo Collado-Torres
}
