% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareBins.R
\name{prepareBins}
\alias{prepareBins}
\title{prepareBins}
\usage{
prepareBins(
  g,
  APA = NULL,
  onlyMainChr = TRUE,
  removeAntisense = TRUE,
  chrStyle = NULL,
  maxUTRbinSize = 15000,
  codingOnly = FALSE,
  genewise = FALSE,
  stranded = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{g}{A GRanges (or path to RDS file containing a GRanges) or path to a
gtf file or EnsDb object containing the gene annotation.}

\item{APA}{A GRanges (or path to a GRanges in RDS format) or bed file
containing the alternative poly-A site database}

\item{onlyMainChr}{Logical; whether to keep only main chromosomes}

\item{removeAntisense}{Logical; whether to remove antisense APA sites}

\item{chrStyle}{Chromosome notation to convert to (default no conversion)}

\item{maxUTRbinSize}{Max width of new alternative UTR bins}

\item{codingOnly}{Logical, whether to keep only coding transcripts}

\item{genewise}{Logical, whether annotation should be flattened genewise}

\item{stranded}{Logical, whether to perform disjoin in a stranded fashion.}

\item{verbose}{Logical, whether to print run information}
}
\value{
A `GRanges` object.
}
\description{
prepareBins
}
\details{
See the vignette for more details.
}
\examples{
data(example_gene_annotation)
bins <- prepareBins(example_gene_annotation)
}
\author{
Stefan Greber
}
