% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-getters.R
\name{metaLevels}
\alias{metaLevels}
\title{Gives the distinct values of a meta.data slot (or ident)}
\usage{
metaLevels(meta, object, cells.use = NULL, used.only = TRUE)
}
\arguments{
\item{meta}{quoted "meta.data.slot" name = REQUIRED. the meta.data slot whose potential values should be retrieved.}

\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{cells.use}{String vector of cells'/samples' names OR an integer vector specifying the indices of cells/samples which should be included.

Alternatively, a Logical vector, the same length as the number of cells in the object, which sets which cells to include.}

\item{used.only}{TRUE by default, for target metadata that are factors, whether levels nonexistent in the target data should be ignored.}
}
\value{
String vector, the distinct values of a metadata slot (factor or not) among all cells/samples, or for a subset of cells/samples.
(Alternatively, returns the distinct values of clustering if \code{meta = "ident"} and the object is a \code{Seurat} object).
}
\description{
Gives the distinct values of a meta.data slot (or ident)
}
\examples{
example(importDittoBulk, echo = FALSE)

metaLevels("clustering", object = myRNA)

# Note: Set 'used.only' (default = TRUE) to FALSE to show unused levels
#  of metadata that are already factors.  By default, only the in use options
#  of a metadata are shown.
metaLevels("clustering", myRNA,
    used.only = FALSE)

}
\seealso{
\code{\link{meta}} for returning an entire metadata slots of an \code{object}, not just the potential levels

\code{\link{getMetas}} for returning all metadata slots of an \code{object}

\code{\link{isMeta}} for testing whether something is the name of a metadata slot
}
\author{
Daniel Bunis
}
