% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_plotters.R
\name{multi_dittoDimPlotVaryCells}
\alias{multi_dittoDimPlotVaryCells}
\title{Generates multiple dittoDimPlots, for a single feature, where each showing different cells}
\usage{
multi_dittoDimPlotVaryCells(
  object,
  var,
  vary.cells.meta,
  vary.cells.levels = metaLevels(vary.cells.meta, object),
  show.titles = TRUE,
  show.allcells.plot = TRUE,
  allcells.main = "All Cells",
  show.legend.single = TRUE,
  show.legend.plots = FALSE,
  show.legend.allcells.plot = FALSE,
  nrow = NULL,
  ncol = NULL,
  list.out = FALSE,
  OUT.List = NULL,
  ...,
  assay = .default_assay(object),
  slot = .default_slot(object),
  adjustment = NULL,
  min = NULL,
  max = NULL,
  color.panel = dittoColors(),
  colors = seq_along(color.panel),
  data.out = FALSE,
  do.hover = FALSE,
  swap.rownames = NULL
)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{var}{String name of a "gene" or "metadata" (or "ident" for a Seurat \code{object}) to use for coloring the plots.
This is the data that will be displayed, using colors, for each cell/sample.

Alternatively, can be a vector of same length as there are cells/samples in the \code{object}.
Discrete or continuous data both work.}

\item{vary.cells.meta}{String name of a metadata that should be used for selecting which cells to show in each "VaryCells" \code{\link{dittoDimPlot}}.}

\item{vary.cells.levels}{The values/groupings of the \code{vary.cells.meta} metadata for which to generate a plot.}

\item{show.titles}{Logical which sets whether grouping-levels should be used as titles for the individual VaryCell plots. Default = TRUE.}

\item{show.allcells.plot}{Logical which sets whether an additional plot showing all of the cells should be added.}

\item{allcells.main}{String which adjusts the title of the allcells plot. Default = "All Cells".  Set to \code{NULL} to remove.}

\item{show.legend.single}{Logical which sets whether to add a single legend as an additional plot. Default = TRUE.}

\item{show.legend.plots}{Logical which sets whether or not legends should be plotted in inidividual VaryCell plots. Default = FALSE.}

\item{show.legend.allcells.plot}{Logical which sets whether or a legend should be plotted in the allcells plot. Default = FALSE.}

\item{ncol, nrow}{Integers which set dimensions of the plot grid when \code{list.out = FALSE}.}

\item{list.out}{Logical which controls whether the list of plots should be returned as a list instead of as a single grid arrangement of the plots.}

\item{OUT.List}{Deprecated. Use \code{list.out}}

\item{..., color.panel, colors, min, max, assay, slot, adjustment, data.out, do.hover, swap.rownames}{additional parameters passed to \code{\link{dittoDimPlot}}.

All parameters of \code{\link{dittoDimPlot}} can be utilized and adjusted except for \code{cells.use}, \code{main}, and \code{legend.show} which are handled with alternative methods here.
A few suggestions: \code{reduction.use} for setting which dimensionality reduction space to use.
\code{xlab} and \code{ylab} can be set to \code{NULL} to remove the axes labels and provide extra room for the data.
\code{size} can be used to adjust the size of the dots.}
}
\value{
A set of dittoDimPlots either arranged into a grid (default), or output as a list.
}
\description{
Generates multiple dittoDimPlots, for a single feature, where each showing different cells
}
\details{
This function generates separate dittoDimPlots that show the same target data, but each for distinct cells.

How cells are separated into distinct plots is controlled with the \code{vary.cells.meta} parameter.
Individual \code{\link{dittoDimPlot}}s are created for all levels of \code{var.cells.meta} groupings given to the \code{vary.cells.levels} input (default = all).

The function then appends a plot containing all cell/samples when \code{show.allcells.plot = TRUE}, with title of this plot controlled by \code{allcells.main},
as well as as single legend when \code{show.legend.single = TRUE}.

By default, these dittoDimPlots are output in a grid (default) with \code{ncol} columns and \code{nrow} rows,
Alternatively, if \code{list.out} is set to \code{TRUE}, they are returned as a list.
In the list, the VaryCell plots will be named by the levels of \code{vary.cells.meta} that they contain,
and the optional allcells plot and single legend will be named "allcells" and "legend", respectively.

Either continuous or discrete \code{var} data can be displayed.
\itemize{
\item For continuous data, the range of potential values is calculated at the start, and set, so that colors represent the same value across all plots.
\item For discrete data, colors used in each plot are adjusted so that colors represent the same groupings across all plots.
}
}
\examples{
example(importDittoBulk, echo = FALSE)

# This function can be used to quickly scan for differences in expression
#   within or across clusters/cell types.
multi_dittoDimPlotVaryCells(myRNA, "gene1", vary.cells.meta = "clustering")

# Output as list instead
multi_dittoDimPlotVaryCells(myRNA, "gene1", vary.cells.meta = "clustering",
    list.out = TRUE)

# This function is also great for generating separate plots of each individual
#   grouping of a tsne/PCA/umap. This can be useful to check for dispersion
#   of groups that might otherwise be hidden behind other cells/samples.
#   The effect is similar to faceting, but: all distinct plots are treated
#   separately rather than being just a part of the whole, and with portrayal
#   of all cells/samples in an additional plot by default.
#
#   To do so, set 'var' and 'vary.cells.meta' the same.
multi_dittoDimPlotVaryCells(myRNA, "clustering", vary.cells.meta = "clustering")

# The function can also be used to quickly visualize how separate clustering
#   resolutions match up to each other, or perhaps how certain conditions of
#   cells disperse across clusters.
# (For an alternative method of viewing, and easily quantifying, how discrete
#   conditions of cells disperse across clusters, see '?dittoBarPlot')
multi_dittoDimPlotVaryCells(myRNA, "groups", vary.cells.meta = "clustering")

}
\seealso{
\code{\link{multi_dittoDimPlot}} for an alternate \code{\link{dittoDimPlot}} multi-plotter where \code{var}s are varied across plots rather than cells/samples

\code{\link{dittoDimPlot}} for the base dittoDimPlot plotting function and details on all accepted inputs.
}
\author{
Daniel Bunis
}
