% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dafsFilter.R
\name{dafsFilter}
\alias{dafsFilter}
\title{dafsFilter Function to filter expression data within an object.}
\usage{
dafsFilter(se, PLOT=TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{PLOT}{Boolean, toggles plotting.}
}
\value{
Returns an invisible, filtered SummExp object.
}
\description{
This function filters the expression of the supplied
object, by invoking the dafsFilter (dafs) function. dafsFilter is a
filtering function used to remove rows (genes) of various expression data.
}
\details{
This function filters the expression of the supplied object
using a Data Adaptive Flag filter. The internal function uses a vector
to store Kolmogorov Smirnov distance statistics, loops through cuts of
the data to determine targeted K-S statistic, selects data greater than
a quantile and runs Mclust on that data to determine theoretical
distribution. The wrapper uses simpleFilter to determine first left-most
local minima (using the Earth library).
}
\examples{
library(mclust)
data(hmel.se)
f_se <- dafsFilter(se)
}
\references{
BMC Bioinformatics, 2014, 15:92
}
\author{
AJ Vaestermark, JR Walters.
}
