% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRatioDensity.R
\name{plotRatioDensity}
\alias{plotRatioDensity}
\title{plotRatioDensity Function to plot density of ratios between two
treatments (using groupings from an annotation column) within an
object.}
\usage{
plotRatioDensity(se, groupings= NULL, treatment1=NULL,
treatment2=NULL, mode_mean=TRUE, LOG2=TRUE,...)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{groupings}{A grouping (annotation); groupings="annotation.ZA"}

\item{treatment1}{Symbol, treatment 1.}

\item{treatment2}{Symbol, treatment 2.}

\item{mode_mean}{Boolean, Calculate RowMeans or RowMedians.}

\item{LOG2}{Boolean, Calculate LOG2.}

\item{...}{Passthrough arguments to boxplot (additional arguments affecting
the summary produced).}
}
\value{
Returns an invisible data frame containing the x-values and
corresponding density for each applicable annotation column entry.
}
\description{
This function plots the expression of the supplied
object, using ratios between a pair of selected treatments.
}
\details{
This function plots expression of the supplied object
using ratios of treatment1/treatment2.
}
\examples{
data(hmel.se)
plotRatioDensity(se, groupings='annotation.ZA', treatment1 = 'Male',
treatment2 = 'Female',lty=1,type="l")
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
