% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ka_ks_analyses.R
\name{pairs2kaks}
\alias{pairs2kaks}
\title{Calculate Ka, Ks, and Ka/Ks from duplicate gene pairs}
\usage{
pairs2kaks(gene_pairs_list, cds, model = "MYN", threads = 1, verbose = FALSE)
}
\arguments{
\item{gene_pairs_list}{List of data frames containing duplicated gene pairs
as returned by \code{classify_gene_pairs()}.}

\item{cds}{List of DNAStringSet objects containing the coding sequences
of each gene.}

\item{model}{Character scalar indicating which codon model to use.
Possible values are "Li", "NG86", "NG", "LWL", "LPB", "MLWL", "MLPB", "GY",
"YN", "MYN", "MS", "MA", "GNG", "GLWL", "GLPB", "GMLWL", "GMLPB", "GYN",
and "GMYN". Default: "MYN".}

\item{threads}{Numeric indicating the number of threads to use. Default: 1.}

\item{verbose}{Logical indicating whether progress messages should be
printed on screen. Default: FALSE.}
}
\value{
A list of data frames containing gene pairs and their Ka, Ks,
and Ka/Ks values.
}
\description{
Calculate Ka, Ks, and Ka/Ks from duplicate gene pairs
}
\examples{
data(diamond_intra)
data(diamond_inter)
data(yeast_annot)
data(yeast_seq)
data(cds_scerevisiae)
blast_list <- diamond_intra
blast_inter <- diamond_inter

pdata <- syntenet::process_input(yeast_seq, yeast_annot)
annot <- pdata$annotation["Scerevisiae"]

# Binary classification scheme
pairs <- classify_gene_pairs(annot, blast_list)
td_pairs <- pairs[[1]][pairs[[1]]$type == "TD", ]
gene_pairs_list <- list(
    Scerevisiae = td_pairs[seq(1, 3, by = 1), ]
)

cds <- list(Scerevisiae = cds_scerevisiae)

kaks <- pairs2kaks(gene_pairs_list, cds)

}
