% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\docType{methods}
\name{plotHeatmap}
\alias{plotHeatmap}
\alias{plotHeatmap,cellSpecificityValues-method}
\alias{plotHeatmap,cellSpecificityValues,cellSpecificityValues-method}
\alias{plotHeatmap,data.frame-method}
\alias{plotHeatmap,data.frame,data.frame-method}
\alias{plotHeatmap,matrix-method}
\alias{plotHeatmap,matrix,matrix-method}
\title{Plot heatmap}
\usage{
plotHeatmap(
  x,
  genes = rownames(x),
  color = "darkblue",
  assays = colnames(x),
  useFillScale = TRUE
)

\S4method{plotHeatmap}{cellSpecificityValues}(
  x,
  genes = rownames(x),
  color = "darkblue",
  assays = colnames(x),
  useFillScale = TRUE
)

\S4method{plotHeatmap}{data.frame}(
  x,
  genes = rownames(x),
  color = "darkblue",
  assays = colnames(x),
  useFillScale = TRUE
)

\S4method{plotHeatmap}{matrix}(
  x,
  genes = rownames(x),
  color = "darkblue",
  assays = colnames(x),
  useFillScale = TRUE
)
}
\arguments{
\item{x}{fractions for each gene}

\item{genes}{name of genes to plot}

\item{color}{color of heatmap}

\item{assays}{array of assays to plot}

\item{useFillScale}{default TRUE. add scale_fill_gradient() to plot}
}
\value{
heatmap
}
\description{
Plot heatmap
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# Compute cell type specificity of each gene
df <- cellTypeSpecificity(pb)

# For each cell type, get most specific gene
genes <- rownames(df)[apply(df, 2, which.max)]

# heatmap of 5 genes that are most cell type specific
dreamlet::plotHeatmap(df, genes = genes)
}
