% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize_TMB.R
\name{categorize_TMB}
\alias{categorize_TMB}
\title{Define tumor mutational burden (TMB) categories.}
\usage{
categorize_TMB(TMB, thresholds = NULL)
}
\arguments{
\item{TMB}{numeric vector with tumor mutational burden values.}

\item{thresholds}{numeric vector to specify thresholds to be used.
Default thresholds are low (<100), moderate (100-400) and
high TMB (>400).}
}
\value{
A numeric vector assigning each sample a class
from 1 (low TMB) to 3 (high TMB).
}
\description{
Encodes tumor mutational burden (TMB)
from numerical into categorical variable.
}
\examples{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")
dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()

TMB <- colData(dataset_mariathasan)[["TMB"]]
names(TMB) <- colData(dataset_mariathasan)[["pat_id"]]

# Convert TMB continous values into categories
TMB_cat <- categorize_TMB(TMB = TMB)
}
