% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\docType{data}
\name{endotoxin}
\alias{endotoxin}
\title{Gene expression dataset from Calvano et al. (2005) Nature}
\format{\itemize{
  \item endoexpr: A 500 rows by 46 columns data frame containing expression
  values.
  \item class: A vector of length 46 containing information about which
  individuals were given endotoxin.
  \item ind: A vector of length 46 providing indexing measurements for each
  individual in the experiment.
  \item time: A vector of length 46 indicating time measurements.
}}
\usage{
data(endotoxin)
}
\value{
endotoxin dataset
}
\description{
The data provide gene expression measurements in an endotoxin study where
four subjects were given endotoxin and four subjects were given a placebo.
Blood samples were collected and leukocytes were isolated from the samples
before infusion and at times 2, 4, 6, 9, 24 hours.
}
\note{
The data is a random subset of 500 genes from the full dataset. To
download the full data set, go to \url{http://genomine.org/edge/}.
}
\examples{
library(splines)
# import data
data(endotoxin)
ind <- endotoxin$ind
class <- endotoxin$class
time <- endotoxin$time
endoexpr <- endotoxin$endoexpr
cov <- data.frame(individual = ind, time = time, class = class)

# formulate null and full models in experiement
# note: interaction term is a way of taking into account group effects
mNull <- ~ns(time, df=4, intercept = FALSE) + class
mFull <- ~ns(time, df=4, intercept = FALSE) +
          ns(time, df=4, intercept = FALSE):class + class

# create deSet object
de_obj <- build_models(endoexpr, cov = cov, full.model = mFull,
                       null.model = mNull, ind = ind)

# Perform ODP/lrt statistic to determine significant genes in study
de_odp <- odp(de_obj, bs.its = 10)
de_lrt <- lrt(de_obj, nullDistn = "bootstrap", bs.its = 10)

# summarize significance results
summary(de_odp)
}
\references{
Storey JD, Xiao W, Leek JT, Tompkins RG, and Davis RW. (2005) Significance
analysis of time course microarray experiments. PNAS, 102: 12837-12842. \cr
\url{http://www.pnas.org/content/100/16/9440.full}
}
\keyword{datasets}

