% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/deSet-methods.R
\docType{methods}
\name{lrt}
\alias{lrt}
\alias{lrt,deSet,deFit-method}
\alias{lrt,deSet,missing-method}
\title{Performs F-test (likelihood ratio test using Normal likelihood)}
\usage{
lrt(object, de.fit, nullDistn = c("normal", "bootstrap"), weights = NULL,
  bs.its = 100, seed = NULL, verbose = TRUE, mod.F = FALSE, ...)

\S4method{lrt}{deSet,missing}(object, de.fit, nullDistn = c("normal",
  "bootstrap"), weights = NULL, bs.its = 100, seed = NULL,
  verbose = TRUE, mod.F = FALSE, ...)

\S4method{lrt}{deSet,deFit}(object, de.fit, nullDistn = c("normal",
  "bootstrap"), weights = NULL, bs.its = 100, seed = NULL,
  verbose = TRUE, mod.F = FALSE, ...)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}.}

\item{de.fit}{\code{S4 object}: \code{\linkS4class{deFit}}. Optional.}

\item{nullDistn}{\code{character}: either "normal" or "bootstrap", If
"normal" then the p-values are calculated using the F distribution. If
"bootstrap" then a bootstrap algorithm is implemented to simulate
statistics from the null distribution. In the "bootstrap" case, empirical
p-values are calculated using the observed and null statistics (see
\code{\link{empPvals}}). Default is "normal".}

\item{weights}{\code{matrix}: weights for each observation. Default is NULL.}

\item{bs.its}{\code{integer}: number of null statistics generated (only
applicable for "bootstrap" method). Default is 100.}

\item{seed}{\code{integer}: set the seed value. Default is NULL.}

\item{verbose}{\code{boolean}: print iterations for bootstrap method.
Default is TRUE.}

\item{mod.F}{\code{boolean}: Moderated F-test, recommended for experiments
with a small sample size. Default is FALSE.}

\item{...}{Additional arguments for \code{\link{apply_qvalue}} and
\code{\link{empPvals}} function.}
}
\value{
\code{\linkS4class{deSet}} object
}
\description{
\code{lrt} performs a generalized likelihood ratio test using the full and
null models.
}
\details{
\code{lrt} fits the full and null models to each gene using the
function \code{\link{fit_models}} and then performs a likelihood ratio test.
The user has the option to calculate p-values a Normal distribution
assumption or through a bootstrap algorithm. If \code{nullDistn} is
"bootstrap" then empirical p-values will be determined from the
\code{\link{qvalue}} package (see \code{\link{empPvals}}).
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# lrt method
de_lrt <- lrt(de_obj, nullDistn = "normal")

# to generate p-values from bootstrap
de_lrt <- lrt(de_obj, nullDistn = "bootstrap", bs.its = 30)

# input a deFit object directly
de_fit <- fit_models(de_obj, stat.type = "lrt")
de_lrt <- lrt(de_obj, de.fit = de_fit)

# summarize object
summary(de_lrt)

}
\author{
John Storey, Andrew Bass
}
\references{
Storey JD, Xiao W, Leek JT, Tompkins RG, and Davis RW. (2005) Significance
analysis of time course microarray experiments. Proceedings of the National
Academy of Sciences, 102: 12837-12842.

\url{http://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\seealso{
\code{\linkS4class{deSet}}, \code{\link{build_models}},
\code{\link{odp}}
}

