% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/treeplot.R
\name{treeplot}
\alias{treeplot}
\alias{treeplot,enrichResult-method}
\alias{treeplot,gseaResult-method}
\alias{treeplot,compareClusterResult-method}
\alias{treeplot_internal}
\title{treeplot}
\usage{
treeplot(x, ...)

\S4method{treeplot}{enrichResult}(x, ...)

\S4method{treeplot}{gseaResult}(x, ...)

\S4method{treeplot}{compareClusterResult}(x, ...)

treeplot_internal(
  x,
  showCategory = 30,
  color = "p.adjust",
  size_var = c("Count", "setSize"),
  nCluster = 5,
  cluster_method = "ward.D",
  label_format = 30,
  fontsize_tiplab = 4,
  fontsize_cladelab = 4,
  group_color = NULL,
  extend = 0.3,
  hilight = TRUE,
  align = "both",
  hexpand = 0.1,
  tiplab_offset = 0.2,
  cladelab_offset = 1
)
}
\arguments{
\item{x}{enrichment result.}

\item{...}{additional parameters}

\item{showCategory}{number of enriched terms to display}

\item{color}{variable to color nodes, e.g. 'p.adjust', 'pvalue', or 'qvalue'}

\item{size_var}{variable for node size, e.g. 'Count' (for enrichResult) or 'setSize' (for gseaResult)}

\item{nCluster}{number of clusters for tree cutting}

\item{cluster_method}{hierarchical clustering method}

\item{label_format}{wrap length for labels or custom formatting function}

\item{fontsize_tiplab}{font size for tip labels}

\item{fontsize_cladelab}{font size for clade labels}

\item{group_color}{vector of colors for groups}

\item{extend}{extend length for clade labels}

\item{hilight}{whether to highlight clades}

\item{align}{alignment for highlight rectangles}

\item{hexpand}{expand x limits by amount of xrange * hexpand}

\item{tiplab_offset}{offset for tip labels}

\item{cladelab_offset}{offset for clade labels}
}
\value{
ggplot object

ggplot2 object representing the tree plot
}
\description{
Functional grouping tree diagram for enrichment result of
over-representation test or gene set enrichment analysis.

Creates hierarchical tree visualization of enriched terms based on similarity
}
\details{
This function visualizes gene sets as a tree.
Gene sets with high similarity tend to cluster together, making it easier
for interpretation.
}
\examples{
\dontrun{
    library(clusterProfiler)
    library(org.Hs.eg.db)
    library(enrichplot)
    library(GOSemSim)
    library(ggplot2)
    library(DOSE)
    data(geneList)
    gene <- names(geneList)[abs(geneList) > 2]
    ego <- enrichGO(gene  = gene,
        universe      = names(geneList),
        OrgDb         = org.Hs.eg.db,
        ont           = "BP",
        pAdjustMethod = "BH",
        pvalueCutoff  = 0.01,
        qvalueCutoff  = 0.05,
        readable      = TRUE)
    d <- godata('org.Hs.eg.db', ont="BP")
    ego2 <- pairwise_termsim(ego, method = "Wang", semData = d)
    treeplot(ego2, showCategory = 30)
    # use `hilight = FALSE` to remove ggtree::geom_hilight() layer.
    treeplot(ego2, showCategory = 30, hilight = FALSE)
    # use `offset` parameter to adjust the distance of bar and tree.
    treeplot(ego2, showCategory = 30, hilight = FALSE, offset = rel(1.5))
    # use `offset_tiplab` parameter to adjust the distance of nodes and branches.
    treeplot(ego2, showCategory = 30, hilight = FALSE, offset_tiplab = rel(1.5))
    keep <- rownames(ego2@termsim)[c(1:10, 16:20)]
    keep
    treeplot(ego2, showCategory = keep)
    treeplot(ego2, showCategory = 20,
        group_color = c("#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442"))
    # It can also graph compareClusterResult
    data(gcSample)
    xx <- compareCluster(gcSample, fun="enrichKEGG",
                         organism="hsa", pvalueCutoff=0.05)
    xx <- pairwise_termsim(xx)
    treeplot(xx)

    # use `geneClusterPanel` to change the gene cluster panel.
    treeplot(xx, geneClusterPanel = "dotplot")

    treeplot(xx, geneClusterPanel = "pie")
   }
}
