% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBinning.R
\name{plotBinning}
\alias{plotBinning}
\title{plotBinning()}
\usage{
plotBinning(
  rse,
  target_height = 650,
  palette = colorRampPalette(c("#DF536B", "black", "#61D04F"))
)
}
\arguments{
\item{rse}{a RangedSummarizedExperiment input with a column \code{bin} in
\code{rowRanges(rse)}.
Alternatively (for backward compatibility),
a GRanges object or any object such as \code{rse$bin} exists.}

\item{target_height}{an integer, the approximate height (in pixels)
of the final plot. Used to avoid overplotting artefacts.}

\item{palette}{A vector of colors, or a function that returns
a palette of \code{n} colors.}
}
\value{
Display a plot.
}
\description{
Plot a vertical color bar of the \code{bin} column.
}
\examples{
data("stackepi")
rse <- stackepi
rse <- addBins(rse, nbins = 3)
plotBinning(rse)

gr2 <- data.frame(bin = rep(c(1,2,3,4), each = 5))
plotBinning(gr2, palette = colorRampPalette(c("blue4", "forestgreen", "coral3", "goldenrod")))

}
