% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizEnvironment-class.R
\docType{class}
\name{EpivizEnvironment-class}
\alias{EpivizEnvironment-class}
\alias{EpivizEnvironment}
\title{Data container for an Epiviz environment component.}
\description{
Data container for an Epiviz environment component.
}
\section{Fields}{

\describe{
\item{\code{charts}}{List of class \code{\link{EpivizViewComponent}} used to track nested elements.}

\item{\code{interactive}}{Logical value of whether componenet is interactive with data source componenet..}

\item{\code{epiviz_ds}}{\code{\link{EpivizDataSource}} object for interactive documents.}
}}

\section{Methods}{

\describe{
\item{\code{add_data(...)}}{Add data to environment's data manager
\describe{
  \item{...}{Arguments for add_measurements and register, e.g., data,
  datasource_name, datasource_obj_name, type, etc}
}}

\item{\code{add_genome(genome, type = "gene_info", datasource_name = NULL)}}{Add a genome to the view, and a genes-track.
\describe{
  \item{genome}{annotation object. eg. Homo.sapiens}
}}

\item{\code{append_chart(chart)}}{Append chart or navigation to environment}

\item{\code{append_region(chr = NULL, start = NULL, end = NULL, ...)}}{Add a child Navigation element to the given genomic region}

\item{\code{get_charts()}}{Get charts within environment}

\item{\code{get_component_type()}}{Get component type for prefix of random id generator}

\item{\code{get_measurements()}}{Get measurements}

\item{\code{get_name()}}{Get name of Epiviz Web Component}

\item{\code{get_rows(...)}}{Get row data from environment's data manager}

\item{\code{get_values(...)}}{Get value data from environment's data manager}

\item{\code{init_region(chr = NULL, start = NULL, end = NULL)}}{Initialize navigation based on a genomic region
\describe{
  \item{chr}{Chromosome}
  \item{start}{Start location}
  \item{end}{End location}
}}

\item{\code{init_regions(regions)}}{Initialize navigations based on genomic regions
\describe{
  \item{regions}{List of named lists of genomic locations, e.g.,
  list(list(chr='chr11', start=99800000, end=103383180))}
}}

\item{\code{is_interactive()}}{Return whether the environment is interactive with a data source}

\item{\code{navigate(chr = NULL, start = NULL, end = NULL)}}{Navigate environment to genomic location
\describe{
  \item{chr}{Chromosome}
  \item{start}{Start location}
  \item{end}{End location}
}}

\item{\code{order_charts(ordered_charts)}}{Order the charts within an environment
\describe{
\item{charts}{An ordered list of EpivizViewComponent objects}
}}

\item{\code{plot(...)}}{Plot an EpivizChart within the environment
 \describe{
  \item{...}{Arguments for epivizChart}
}}

\item{\code{register_shiny_handler(session)}}{Enable components to interact with Shiny session.
\describe{
  \item{session}{Shiny session object}
}}

\item{\code{remove_all_charts()}}{Remove all charts from environment}

\item{\code{remove_chart(chart)}}{Remove chart from environment}

\item{\code{render_component(shiny = FALSE)}}{Render to html
\describe{
  \item{shiny}{ if rendering component in a shiny environment}
}}

\item{\code{set_charts(charts)}}{Set charts of environment}
}}

