% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-inits.R
\name{epivizChart}
\alias{epivizChart}
\title{Initialize an \code{\link{EpivizChart}} object to visualize in viewer or knit to HTML.}
\usage{
epivizChart(
  data_obj = NULL,
  measurements = NULL,
  datasource_name = NULL,
  parent = NULL,
  chart = NULL,
  chr = NULL,
  start = NULL,
  end = NULL,
  settings = NULL,
  colors = NULL,
  ...
)
}
\arguments{
\item{data_obj}{A data object that will register to an \code{\link{EpivizData}} object.}

\item{measurements}{An \code{\link{EpivizMeasurement}} object.}

\item{datasource_name}{A name for the datasource. For example, "Mean by Sample Type".}

\item{parent}{An object of class \code{\link{EpivizEnvironment}} or \code{\link{EpivizNavigation}} to append the chart within.}

\item{chart}{The chart type to be visualized: "BlocksTrack", HeatmapPlot", "LinePlot", "LineTrack", "ScatterPlot", "StackedLinePlot", "StackedLineTrack".}

\item{chr}{The chromosome to filter on, e.g., chr="chr11".}

\item{start}{The start location, e.g., start=110800000.}

\item{end}{The end location, e.g., end=130383180.}

\item{settings}{List of settings, e.g., list(title="Blocks Chart").}

\item{colors}{List of colors. When chart is rendered to html this will be converted to a string encoded as JSON}

\item{...}{Additional arguments passed to \code{\link[epivizrData:register]{epivizrData::register}}, e.g., \code{type="bp"}, \code{columns=c("normal, cancer")}.}
}
\value{
An object of class \code{\link{EpivizChart}}.
}
\description{
Initialize an \code{\link{EpivizChart}} object to visualize in viewer or knit to HTML.
}
\examples{
data(tcga_colon_blocks)
start <- 99800000
end <- 103383180
blocks_track <- epivizChart(tcga_colon_blocks, chr="chr11", start=start, end=end)
# See package vignette for more examples.

}
