% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveERCCPlots.R
\name{saveERCCPlots}
\alias{saveERCCPlots}
\title{Save erccdashboard plots to a pdf file}
\usage{
saveERCCPlots(
  exDat,
  plotsPerPg = "main",
  saveas = "pdf",
  outName = NULL,
  plotlist = NULL,
  res = 200
)
}
\arguments{
\item{exDat}{list, contains input data and stores analysis results}

\item{plotsPerPg}{string, if "main" then the 4 main plots are printed
to one page, if "single" then a single plot is printed 
per page from the plotlist argument}

\item{saveas}{Choose file format from "pdf", "jpeg" or "png"}

\item{outName}{Choose output file name, default will be fileName from exDat}

\item{plotlist}{list, contains plots to print}

\item{res}{Choose the file resolution}
}
\description{
The function savePlots will save selected figures to a pdf file. The default 
is the 4 manuscript figures to a single page (plotsPerPg = "manuscript"). 
If plotsPerPg = "single" then each plot is placed on an 
individual page. If plotlist is not defined (plotlist = NULL) or 
if plotlist = exDat$Figures then all plots in exDat$Figures are printed to a PDF file.
}
\examples{
\dontrun{
data(SEQC.Example)
 
exDat <- initDat(datType="count", isNorm=FALSE, exTable=MET.CTL.countDat, 
                 filenameRoot="testRun", sample1Name="MET",
                 sample2Name="CTL", erccmix="RatioPair", 
                 erccdilution=1/100, spikeVol=1, totalRNAmass=0.500,
                 choseFDR=0.1)
                 
exDat <- est_r_m(exDat)
                  
exDat <- dynRangePlot(exDat)

exDat <- geneExprTest(exDat)

exDat <- erccROC(exDat)

exDat <- estLODR(exDat, kind="ERCC", prob=0.9)

exDat <- annotLODR(exDat)

#to print 4 main plots to a single page pdf file
saveERCCPlots(exDat, plotsPerPg = "main",saveas = "pdf")

#to print 4 plots to a jpeg file
saveERCCPlots(exDat, plotsPerPg = "main",saveas = "jpeg")

# or to create a multiple page pdf of all plots produced
saveERCCPlots(exDat, plotsPerPg = "single", plotlist = exDat$Figures)


}


}
