% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{write.FCS}
\alias{write.FCS}
\title{Write an FCS file}
\usage{
write.FCS(x, filename, what="numeric", delimiter = "|", endian="big")
}
\arguments{
\item{x}{A \code{\link[flowCore:flowFrame-class]{flowFrame}}.}

\item{filename}{A character scalar giving the output file name.}

\item{what}{A character scalar defining the output data type. One in
\code{integer}, \code{numeric}, \code{double}. Note that forcing the data
type to \code{integer} may result in considerable loss of precision if the
data has been transformed. We recommend using the default data type unless
disc space is an issue.}

\item{delimiter}{a single character to separate the FCS keyword/value pairs.
Default is : "|"}

\item{endian}{a character, either "little" or "big" (default), specifying
the most significant or least significant byte is stored first in a 32 bit
word.}
}
\value{
A character vector of the file name.
}
\description{
Write FCS file from a flowFrame
}
\details{
The function \code{write.FCS} creates FCS 3.0 standard file from an object
of class \code{flowFrame}.

For specifications of FCS 3.0 see \url{http://www.isac-net.org} and the file
\url{../doc/fcs3.html} in the \code{doc} directory of the package.
}
\examples{

## a sample file
inFile <- system.file("extdata", "0877408774.B08", package="flowCore")
foo <- read.FCS(inFile, transform=FALSE)
outFile <- file.path(tempdir(), "foo.fcs")

## now write out into a file
write.FCS(foo, outFile)
bar <- read.FCS(outFile, transform=FALSE)
all(exprs(foo) == exprs(bar))


}
\seealso{
\code{link[flowCore]{write.flowSet}}
}
\author{
F. Hahne
}
\keyword{IO}
