% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_summary_tables}
\alias{fg_get_summary_tables}
\title{Retrieves a table containing all node or edge summary statistics.}
\usage{
fg_get_summary_tables(fg, type = "node")
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summaries the user
wants to retrieve were created for, 'node' or 'edge'.}
}
\value{
A list; this output is the same as that of function
 \code{fg_get_graph} with additional columns.
 These columns contain summary statistics from the \code{summary}
 slot of the flowGraph object. These columns are named:
 <feature type: node/edge>.<feature>.<summary name>.<class>.<class labels>.
}
\description{
Retrieves a table containing all node or edge summary statistics
 given a flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 fg <- fg_summary(fg, no_cores=no_cores, class="class", label1="control",
                  overwrite=FALSE, test_name="t", diminish=FALSE)
 show(fg)

 feat_summ_table_node <- fg_get_summary_tables(fg, type="node")
 head(feat_summ_table_node)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_means}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_get_feature}}
}
