% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakNorm.R
\name{peakNorm}
\alias{peakNorm}
\title{Normalize batch differences in intensities by aligning peaks}
\usage{
peakNorm(
  fs,
  ctrlPos,
  standFF,
  transNames = FALSE,
  transCoFacs,
  volThresh = 0.005,
  normOrNot = rep(TRUE, ncol(standFF))
)
}
\arguments{
\item{fs}{The flowSet to be normalized}

\item{ctrlPos}{The position in the flowSet that contains the internal
control}

\item{standFF}{The external standard to which all batches should be
normalized}

\item{transNames}{If parameters are not transformed prior to running this,
internal transformation is necessary to identify peaks, so specify which
variables that need transformation here. The data for these variables
are untransformed at the end, so the data will have the same scale in and
out.}

\item{transCoFacs}{Also inherited from arcTrans. Low values (2-10) for CyTOF
data, high values (200-2000) for flow data, all depending on the number of
input channels.}

\item{volThresh}{The threshold for how small the area of a peak can be compared to
the largest peak, and still count.}

\item{normOrNot}{This needs to be a logical vector with the same length as the
number of columns in the fs and standFF. If it is known that a certain
variable should not be normalized, that information can be specified
here.}
}
\value{
A normalized flowSet. In addition, output to console, to clarify
#for which markers the same number of peaks was detected in the control and
the standard, as normalization will only be applied for these.
}
\description{
This function is intended to be used on standardized controls,
preferrably one standard that has been acquired with every batch.
This function needs to be applied separately for each batch, with the same
standard.
}
\examples{
#Load uncompensated data and spectral matrix.
data(fullPanel)
data(specMat)

# And now unmix
fullPanelUnmix <- specUnmix(fullPanel, specMat)

 #Create a new file with the value 1000 added to all values
 library(flowCore)
 fullPanelPlus1000 <- flowFrame(exprs(fullPanelUnmix)+1000)
# Check how they differ.
range(exprs(fullPanelUnmix)[,1])
# 143 1187733
range(exprs(fullPanelPlus1000)[,1])
# 1143 1188733

#Now normalize the new one to the old. NB! Here we will only
normPanel1000 <- peakNorm(flowSet(fullPanelPlus1000), 1, fullPanelUnmix,
transNames = colnames(fullPanelUnmix)[6:18], transCoFacs = 500)

#And now check the new result
range(exprs(normPanel1000[[1]] )[,1])
# 143 1187733
}
