% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specUnmix.R
\name{specUnmix}
\alias{specUnmix}
\title{Spectral unmixing of cytometry files}
\usage{
specUnmix(flowObj, specMat)
}
\arguments{
\item{flowObj}{The fcs object to be filtered. Both flowFrames and flowSets
are accepted.}

\item{specMat}{This is a matrix generated by the secMatCalc function,
possibly with edited row names.}
}
\value{
The unmixed data. It will be returned in the format it was imported
as.
}
\description{
This function performs the central task of spectral unmixing, to convert the
raw photon detector input to "biological" proxy-signals.
}
\examples{
# Load uncompensated data
data(fullPanel)

# Load the spectral unmixing matrix generated with controls from the same
# experiment. These can be generated using the specMatCalc function.
data(specMat)

# And now, just run the function
fullPanelUnmix <- specUnmix(fullPanel, specMat)
}
