\name{landmarkMatrix}
\alias{landmarkMatrix}


\title{ Compute and cluster high density regions in 1D }

\description{
  
  This functions first identifies high-density regions for each
  \code{\link[flowCore:flowFrame-class]{flowFrame}} in a
  \code{\link[flowCore:flowSet-class]{flowSet}} and subsequently tries
  to cluster these regions, yielding the landmarks matrix that needs to
  be supplied to \code{\link[fda]{landmarkreg}}. The function is
  considered to be internal. 
  
}

\usage{
landmarkMatrix(data, fres, parm, border=0.05, peakNr=NULL, densities =
NULL, n = 201, indices=FALSE)
}


\arguments{
  
  \item{data}{ A \code{flowSet}. }
  
  \item{fres}{ A list of
    \code{\link[flowCore:filterResultList-class]{filterResultList}}
    objects generated by a filtering opration using a
    \code{\link[flowStats:curv1Filter-class]{curv1Filter}}. Each list
    item represents the results for one of the flow parameters in
    \code{parm}.}
  
  \item{parm}{ Character scalar of flow paramater to compute landmarks
    for. }

  \item{border}{ A numeric in \code{[0,1]}. Ignore all high-density
    regions with mean values in the extreme percentiles of the data
    range. }
  
  \item{peakNr}{ Force a fixed number of peaks. }
  
  \item{densities}{ An optional matrix of y values of the density
    estimates for the \code{flowSet}. If this is not present, density
    estimates will be calculated by the function. }

  \item{n}{ Number of bins used for the density estimation. }

  \item{indices}{ Return matrix of population indices instead of
    landmark locations. These indices can be used to point into the
    populations identified by the curv1Filter.}
  
}

\details{

  In order to normalize the data using the \code{landmarkreg} function
  in the \code{\link[fda:fda-package]{fda}}, a set of landmarks has to
  be computed for each \code{flowFrame} in a \code{flowSet}. The number
  of lansmarks has to be the same for each frame. This function
  identifies high-density regions in each frame, computes a simple
  clustering and returns a matrix of landmark locations. Missing
  landmarks of individual frames are substituted by the mean landmark
  location of the respective cluster.
  
}


\value{
  
  A matrix of landmark locations. Columns are landmarks and rows are
  \code{flowFrames}.
  
}

\author{ Florian Hahne}

\seealso{ \code{\link[fda]{landmarkreg}},\code{\link{warpSet}}  }


\examples{
library(flowCore)
data(GvHD)
tmp <- list("FSC-H"=filter(GvHD[1:3], curv1Filter("FSC-H")))
res <-  flowStats:::landmarkMatrix(GvHD[1:3], tmp, "FSC-H")

}