% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setGate_Methods.R
\name{shift_gate}
\alias{shift_gate}
\alias{shift_gate.GatingHierarchy}
\alias{shift_gate,GatingHierarchy-method}
\alias{shift_gate,GatingSet-method}
\title{Simplified geometric translation of gates associated with nodes}
\usage{
\method{shift_gate}{GatingHierarchy}(obj, y, dx = NULL, dy = NULL, center = NULL, ...)
}
\arguments{
\item{obj}{A \code{GatingHierarchy} or \code{GatingSet} object}

\item{y}{A character specifying the node whose gate should be modified}

\item{dx}{Either a numeric scalar or numeric vector. If it is scalar, this is just the desired shift of the gate in 
its first dimension. If it is a vector, it specifies both \code{dx} and \code{dy} as \code{(dx,dy)}.
This provides an alternate syntax for shifting gates, as well as allowing shifts of \code{ellipsoidGate} objects
in more than 2 dimensions.}

\item{dy}{A numeric scalar specifying the desired shift of the gate in its second dimension.}

\item{center}{A numeric vector specifying where the center or centroid should be moved (rather than specifiying \code{dx} 
and/or \code{dy})}

\item{...}{not used}
}
\description{
Shift the location of a gate associated with a node of a \code{GatingHierarchy} or
\code{GatingSet}. This method is a wrapper for \code{\link[flowCore]{shift_gate}} that enables 
updating of the gate associated with a node of a \code{GatingHierarchy} or \code{GatingSet}.
 
\code{shift_gate} calls \code{\link{gs_pop_set_gate}} to modify the provided \code{GatingHierarchy} or \code{GatingSet} 
directly so there is no need to re-assign its output. The arguments will be essentially identical to the 
\code{flowCore} method, except for the specification of the target gate. Rather than being called on an 
object of type \code{flowCore::filter}, here it is called on a \code{GatingHierarchy} or \code{GatingSet} 
object with an additional character argument for specifying the node whose gate should be transformed. 
The rest of the details below are taken from the \code{flowCore} documentation.
}
\details{
This method allows for geometric translation of filter types defined by simple geometric gates 
(\code{rectangleGate}, \code{quadGate}, \code{\linkS4class{ellipsoidGate}}, or \code{\linkS4class{polygonGate}}).
The method provides two approaches to specify a translation. For \code{rectangleGate} objects, this will
shift the \code{min} and \code{max} bounds by the same amount in each specified dimension. For \code{quadGate}
objects, this will simply shift the divinding boundary in each dimension. For \code{ellipsoidGate} objects, this
will shift the center (and therefore all points of the ellipse). For \code{polgonGate} objects, this will simply
shift all of the points defining the polygon.

The method allows two different approaches to shifting a gate. Through the \code{dx} and/or \code{dy} arguments,
a direct shift in each dimension can be provided. Alternatively, through the \code{center} argument, the gate
can be directly moved to a new location in relation to the old center of the gate. For \code{quadGate} objects, 
this center is the intersection of the two dividing boundaries (so the value of the \code{boundary} slot). For
\code{rectangleGate} objects, this is the center of the rectangle defined by the intersections of the centers
of each interval. For \code{ellipsoidGate} objects, it is the center of the ellipsoid, given by the \code{mean}
slot. For \code{polygonGate} objects, the centroid of the old polygon will be calculated and shifted to the new
location provided by \code{center} and all other points on the polygon will be shifted by relation to the centroid.
}
\examples{
\dontrun{
# Moves the entire gate +500 in its first dimension and 0 in its second dimension
shift_gate(gs, node, dx = 500)

#Moves the entire gate +250 in its first dimension and +700 in its second dimension
shift_gate(gs, node, dx = 500, dy = 700)

# Same as previous
shift_gate(gs, node, c(500,700))

# Move the gate based on shifting its center to (700, 1000)
shift_gate(gs, node, center = c(700, 1000))
}

}
\seealso{
transform_gate \code{\link[flowCore:shift_gate]{flowCore::shift_gate}}
}
