% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_fobi.R
\name{parse_fobi}
\alias{parse_fobi}
\title{Parse FOBI in a Readable Tabular Format}
\usage{
parse_fobi(terms = NULL, get = NULL)
}
\arguments{
\item{terms}{A character vector with FOBI term IDs. Default is NULL.}

\item{get}{A character string indicating desired relationships between provided terms. Options are 'anc' (for ancestors) and 'des' (for descendants). Default is NULL and only information of single input terms will be provided.}
}
\value{
A tibble with FOBI terms information.
}
\description{
This function allows users to download and parse the last version of the Food-Biomarker Ontology into a readable table format.
}
\examples{

# Download and parse whole FOBI
fobi <- parse_fobi()

# Download and parse 'apple' related terms
fobi_apple <- parse_fobi(terms = "FOODON:00002473")

# Download and parse 'apple' term ancestors
fobi_apple_anc <- parse_fobi(terms = "FOODON:00002473", get = "anc")

# Download and parse 'apple' and 'alpha-Chaconine' related terms
fobi_subset <- parse_fobi(terms = c("FOODON:00002473", "CHEBI:10219"))

}
\references{
Pol Castellano-Escuder, Raúl González-Domínguez, David S Wishart, Cristina Andrés-Lacueva, Alex Sánchez-Pla, FOBI: an ontology to represent food intake data and associate it with metabolomic data, Database, Volume 2020, 2020, baaa033, https://doi.org/10.1093/databa/baaa033.
}
\author{
Pol Castellano-Escuder
}
