% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankByRep.R
\name{ct.gRNARankByReplicate}
\alias{ct.gRNARankByReplicate}
\title{Visualization of Ranked gRNA Abundances by Replicate}
\usage{
ct.gRNARankByReplicate(
  eset,
  sampleKey,
  annotation = NULL,
  geneSymb = NULL,
  lib.size = NULL
)
}
\arguments{
\item{eset}{An ExpressionSet object containing, at minimum, count data accessible by exprs() and some phenoData.}

\item{sampleKey}{A sample key, supplied as a (possibly ordered) factor linking the samples to experimental 
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the control set 
is assumed to be the first \code{level}.}

\item{annotation}{An annotation dataframe indicating the nontargeting controls in the geneID column.}

\item{geneSymb}{The \code{geneSymbol} identifier(s) in \code{annotation} that corresponds to gRNAs to be plotted on the curves. 
If the provided value is not present in the \code{geneSymbol}, nontargeting controls will be plotted instead.}

\item{lib.size}{An optional vector of voom-appropriate library size adjustment factors, usually calculated with \code{\link[edgeR]{calcNormFactors}} 
and transformed to reflect the appropriate library size. These adjustment factors are interpreted as the total library sizes for each sample, 
and if absent will be extrapolated from the columnwise count sums of the \code{exprs} slot of the \code{eset}.}
}
\value{
A waterfall plot as specified, on the default device.
}
\description{
This function median scales and log2 transforms the raw gRNA count data contained in an ExpressionSet, 
and then plots the ordered expression values within each replicate. The curve colors are assigned based on a user-
specified column of the pData contained in the ExpressionSet. Optionally, this function can plot the location of Nontargeting control 
guides (or any guides, really) within the distribution.
}
\examples{
data('es')
data('ann')

#Build the sample key
library(Biobase)
sk <- ordered(relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference'))
names(sk) <- row.names(pData(es))

ct.gRNARankByReplicate(es, sk, ann, 'Target1377')
}
\author{
Russell Bainer
}
