% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processFit.R
\name{ct.preprocessFit}
\alias{ct.preprocessFit}
\title{Preprocess a 'MArrayLM' model fit object to include only one contrast.}
\usage{
ct.preprocessFit(fit, modelTerm)
}
\arguments{
\item{fit}{An object of class MArrayLM to be processed.}

\item{modelTerm}{The model coefficient to be isolated for downstream analyses.}
}
\value{
A \code{MArrayLM} object for downstream processing.
}
\description{
This function preprocesses a fit object returned from eBayes to include only the values relevant to the
\code{modelTerm} specified.
}
\examples{

#Load and preprocess data
data('es')
library(Biobase)
library(limma)

#Make a multi-level contrast
design <- model.matrix(~ 0 + TREATMENT_NAME, pData(es))
colnames(design) <- gsub('TREATMENT_NAME', '', colnames(design))
contrasts <- makeContrasts((ControlExpansion - ControlReference), (DeathExpansion - ControlExpansion), levels = design)

#Make a multi-level fit object
vm <- voom(exprs(es), design)
fit <- lmFit(vm, design)
fit <- contrasts.fit(fit, contrasts)
fit <- eBayes(fit)  

#And trim it
fit2  <- ct.preprocessFit(fit, modelTerm = '(DeathExpansion - ControlExpansion)')

ncol(fit)
ncol(fit2)
}
\author{
Russell Bainer
}
\keyword{internal}
