% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_SE.R, R/create_SE.R, R/fit_SE.R,
%   R/normalize_SE.R, R/runDrugResponseProcessingPipeline.R
\name{average_SE}
\alias{average_SE}
\alias{create_SE}
\alias{fit_SE}
\alias{normalize_SE}
\alias{runDrugResponseProcessingPipelineFxns}
\alias{create_and_normalize_SE}
\alias{runDrugResponseProcessingPipeline}
\title{Run drug response processing pipeline}
\usage{
average_SE(
  se,
  data_type,
  series_identifiers = NULL,
  normalized_assay = "Normalized",
  averaged_assay = "Averaged"
)

create_SE(
  df_,
  data_type,
  readout = "ReadoutValue",
  nested_identifiers = NULL,
  nested_confounders = intersect(names(df_), gDRutils::get_env_identifiers("barcode")),
  override_untrt_controls = NULL
)

fit_SE(
  se,
  data_type = "single-agent",
  nested_identifiers = NULL,
  averaged_assay = "Averaged",
  metrics_assay = "Metrics",
  n_point_cutoff = 4,
  range_conc = c(0.005, 5),
  force_fit = FALSE,
  pcutoff = 0.05,
  cap = 0.1,
  curve_type = c("GR", "RV")
)

normalize_SE(
  se,
  data_type,
  nested_identifiers = NULL,
  nested_confounders = gDRutils::get_SE_identifiers(se, "barcode", simplify = TRUE),
  control_mean_fxn = function(x) {
     mean(x, trim = 0.25)
 },
  control_assay = "Controls",
  raw_treated_assay = "RawTreated",
  normalized_assay = "Normalized",
  ndigit_rounding = 4
)

create_and_normalize_SE(
  df_,
  data_type,
  readout = "ReadoutValue",
  control_mean_fxn = function(x) {
     mean(x, trim = 0.25)
 },
  nested_identifiers = NULL,
  nested_confounders = intersect(names(df_), gDRutils::get_env_identifiers("barcode")),
  override_untrt_controls = NULL,
  ndigit_rounding = 4,
  control_assay = "Controls",
  raw_treated_assay = "RawTreated",
  normalized_assay = "Normalized"
)

runDrugResponseProcessingPipeline(
  x,
  readout = "ReadoutValue",
  control_mean_fxn = function(x) {
     mean(x, trim = 0.25)
 },
  nested_identifiers_l = NULL,
  nested_confounders = gDRutils::get_env_identifiers("barcode"),
  override_untrt_controls = NULL,
  ndigit_rounding = 4,
  n_point_cutoff = 4,
  control_assay = "Controls",
  raw_treated_assay = "RawTreated",
  normalized_assay = "Normalized",
  averaged_assay = "Averaged",
  metrics_assay = "Metrics",
  split_data = TRUE,
  data_dir = NULL,
  partial_run = FALSE,
  start_from = get_pipeline_steps()[1],
  selected_experiments = NULL
)
}
\arguments{
\item{se}{\code{SummarizedExperiment} object.}

\item{data_type}{single-agent vs combination}

\item{series_identifiers}{character vector of identifiers in
\code{measured} or \code{metric} which define a unique data point.}

\item{normalized_assay}{string of the assay name containing the
normalized data. Defaults to \code{"Normalized"}.}

\item{averaged_assay}{string of the name of the averaged assay in the
\linkS4class{SummarizedExperiment}. Defaults to \code{"Averaged"}.}

\item{df_}{data.table of raw drug response data containing both treated and
untreated values. If a column called \code{"BackgroundValue"} exists
in \code{df_}, it will be removed from the \code{readout} column.}

\item{readout}{string of the name containing the cell viability readout
values.}

\item{nested_identifiers}{character vector with the nested_identifiers
for the given SE with a given data_type}

\item{nested_confounders}{Character vector of the nested_confounders for a
given assay. nested_keys is character vector of column names to include in
the data.tables in the assays of the resulting \code{SummarizedExperiment}
object. Defaults to the \code{nested_identifiers} and
\code{nested_confounders} if passed through \code{create_and_normalize_SE}
or \code{runDrugResponseProcessingPipeline}.}

\item{override_untrt_controls}{named list containing defining factors in
the treatments. Defaults to \code{NULL}.}

\item{metrics_assay}{string of the name of the metrics assay to output
in the returned \linkS4class{SummarizedExperiment}
Defaults to \code{"Metrics"}.}

\item{n_point_cutoff}{integer of how many points should be considered the
minimum required to try to fit a curve. Defaults to \code{4}.}

\item{range_conc}{vector of concetrations range values.}

\item{force_fit}{boolean indicating whether or not to force the fit.}

\item{pcutoff}{numeric cutoff value.}

\item{cap}{numeric value representing the value to cap the highest allowed
relative viability at.}

\item{curve_type}{vector of curve type values.}

\item{control_mean_fxn}{function indicating how to average controls.
Defaults to \code{mean(x, trim = 0.25)}.}

\item{control_assay}{string containing the name of the assay representing
the controls in the \code{se}. Defaults to \code{"Controls"}.}

\item{raw_treated_assay}{string containing the name of the assay
representing the raw treated data in the \code{se}.
Defaults to \code{"RawTreated"}.}

\item{ndigit_rounding}{integer indicating number of digits to round to
in calculations. Defaults to \code{4}.}

\item{x}{data.table of MAE with drug response data}

\item{nested_identifiers_l}{list with the nested_identifiers(character v
ectors) for \code{single-agent} and (optionally) for \code{combination} data}

\item{split_data}{boolean indicating whether data provided as the
MultiAssayExperiment should be split again into appropriate data types}

\item{data_dir}{string with the path to the directory with intermediate data
of experiments (qs files). If set to NULL (default) intermediate data is not
saved/read in.}

\item{partial_run}{logical flag indicating if the pipeline should be run
partially (from the step defined with \code{start_from})}

\item{start_from}{string indicating the pipeline step from which partial
run should be launched}

\item{selected_experiments}{character vector with experiments for which
pipeline should be run. This option works only for the pipeline being run
partially (i.e. with \code{partial_run} flag set to \code{TRUE})}
}
\value{
MAE object
}
\description{
Run different components of the gDR drug response processing pipeline.
Either: create a SummarizedExperiment and normalize raw treated and control
data (create_and_normalize_SE), average data (average_SE), or fit the
processed data (fit_SE). See details for more in-depth explanations.
}
\details{
\code{runDrugResponseProcessingPipeline} is made up of 3 separate steps:
\itemize{
\item{"create_and_normalize_SE"}
\item{"average_SE"}
\item{"fit_SE"}
}

For create_and_normalize_SE, this creates a SummarizedExperiment object
from a data.table, where the data.table contains treatments on rows, and
conditions on columns.
A \linkS4class{SummarizedExperiment} object containing two asssays is
created: treated readouts will live in an assay called \code{"RawTreated"},
and reference readouts live in an assay called \code{"Controls"}.
Subsequently, the treated and control elements will be normalized to output
two metrics:

For average_SE, take the normalized assay and average the nested
\code{DataFrame}s across unique\code{nested_identifiers}.

For fit_SE, take the averaged assay and fit curves to obtain metrics, one
set of metrics for each normalization type set.

Pipeline can be run partially with \code{partial_run} flag set to TRUE. The
\code{start_from} string defines the step from which the pipeline will be
launched. However, partial run of the pipeline is possible only if the whole
pipeline was launched at least once with defined \code{data_dir} and intermediate
data was saved as qs files into \code{data_dir}.

Pipeline can be run for the selected experiments by changing the default
value of \code{selected_experiments} param. This scenario only works when
\code{partial_run} is enabled.
}
\examples{

d <- rep(seq(0.1, 0.9, 0.1), each = 4)
v <- rep(seq(0.1, 0.4, 0.1), 9)
df <- S4Vectors::DataFrame(
  Concentration = d,
  normalization_type = rep(c("GR", "RV"), length(v) * 2),
  x = rep(v, 2)
)
normalized <- BumpyMatrix::splitAsBumpyMatrix(row = 1, column = 1, x = df)

keys <- list(Trt = "Concentration")
assays <- list("Normalized" = normalized)
se <- SummarizedExperiment::SummarizedExperiment(assays = assays)
se <- gDRutils::set_SE_keys(se, keys)
se <- gDRutils::set_SE_identifiers(se, gDRutils::get_env_identifiers())
se1 <- average_SE(
  se,
  data_type = "single-agent",
  normalized_assay = "Normalized",
  averaged_assay = "Averaged"
)


td <- gDRimport::get_test_data()
l_tbl <- gDRimport::load_data(
  manifest_file = gDRimport::manifest_path(td), 
  df_template_files = gDRimport::template_path(td), 
  results_file = gDRimport::result_path(td)
)
imported_data <- merge_data(
  l_tbl$manifest, 
  l_tbl$treatments, 
  l_tbl$data
)

se <- purrr::quietly(create_SE)(imported_data, data_type = "single-agent")


td <- gDRimport::get_test_data()
l_tbl <- gDRimport::load_data(
  manifest_file = gDRimport::manifest_path(td), 
  df_template_files = gDRimport::template_path(td), 
  results_file = gDRimport::result_path(td)
)
imported_data <- merge_data(
  l_tbl$manifest, 
  l_tbl$treatments, 
  l_tbl$data
)

inl <- prepare_input(imported_data)
se <- create_SE(
 inl$df_list[["single-agent"]],
 data_type = "single-agent",
 nested_confounders = inl$nested_confounders)
 
normalize_SE(se, data_type = "single-agent")
p_dir <- file.path(tempdir(), "pcheck")
dir.create(p_dir) 
td <- gDRimport::get_test_data()
l_tbl <- gDRimport::load_data(
  manifest_file = gDRimport::manifest_path(td), 
  df_template_files = gDRimport::template_path(td), 
  results_file = gDRimport::result_path(td)
)
imported_data <- merge_data(
  l_tbl$manifest, 
  l_tbl$treatments, 
  l_tbl$data
)
runDrugResponseProcessingPipeline(
  imported_data, 
  data_dir = p_dir
)

}
\keyword{runDrugResponseProcessingPipeline}
