% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_bumpy_function}
\alias{apply_bumpy_function}
\title{Apply a function to every element of a bumpy matrix.}
\usage{
apply_bumpy_function(
  se,
  FUN,
  req_assay_name,
  out_assay_name,
  parallelize = FALSE,
  ...
)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object with bumpy matrices.}

\item{FUN}{A function that will be applied to each element of the matrix in assay \code{req_assay_name}.
Output of the function must return a data.table.}

\item{req_assay_name}{String of the assay name in the \code{se} that the \code{FUN} will act on.}

\item{out_assay_name}{String of the assay name that will contain the results of the applied function.}

\item{parallelize}{Logical indicating whether or not to parallelize the computation.}

\item{...}{Additional args to be passed to teh \code{FUN}.}
}
\value{
The original \code{se} object with a new assay, \code{out_assay_name}.
}
\description{
Apply a user-specified function to every element of a bumpy matrix.
}
\examples{
mae <- get_synthetic_data("finalMAE_small.qs")
se <- mae[[1]]
FUN <- function(x) {
  data.table::data.table(Concentration = x$Concentration, CorrectedReadout = x$CorrectedReadout)
} 
apply_bumpy_function(
  se, 
  FUN = FUN, 
  req_assay_name = "RawTreated", 
  out_assay_name = "CorrectedReadout"
)

}
\keyword{package_utils}
