% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_SE.R
\name{merge_assay}
\alias{merge_assay}
\title{Merge assay data}
\usage{
merge_assay(
  SElist,
  assay_name,
  additional_col_name = "data_source",
  discard_keys = NULL
)
}
\arguments{
\item{SElist}{named list of Summarized Experiments}

\item{assay_name}{name of the assay that should be extracted and merged}

\item{additional_col_name}{string of column name that will be
added to assay data for the distinction of possible duplicated metrics
that can arise from multiple projects}

\item{discard_keys}{character vector of string that will be discarded
during creating BumpyMatrix object}
}
\value{
BumpyMatrix or list with data.table + BumpyMatrix
}
\description{
Merge assay data
}
\examples{
mae <- get_synthetic_data("finalMAE_combo_2dose_nonoise")

listSE <- list(
  combo1 = mae[[1]], 
  sa = mae[[2]]
)
merge_assay(listSE, "Normalized")

}
\keyword{SE_operators}
