% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curves.R
\name{predict_efficacy_from_conc}
\alias{predict_efficacy_from_conc}
\title{Predict efficacy values given fit parameters and a concentration.}
\usage{
predict_efficacy_from_conc(c, x_inf, x_0, ec50, h)
}
\arguments{
\item{c}{Numeric vector representing concentrations to predict efficacies for.}

\item{x_inf}{Numeric vector representing the asymptotic value of the sigmoidal fit to the dose-response
data as concentration goes to infinity.}

\item{x_0}{Numeric vector representing the asymptotic metric value corresponding to a concentration of 0
for the primary drug.}

\item{ec50}{Numeric vector representing the drug concentration at half-maximal effect.}

\item{h}{Numeric vector representing the hill coefficient of the fitted curve, which reflects how steep
the dose-response curve is.}
}
\value{
Numeric vector representing predicted efficacies from given concentrations and fit parameters.
}
\description{
Predict efficacy values given fit parameters and a concentration.
}
\details{
The inverse of this function is \code{predict_conc_from_efficacy}.
}
\examples{
predict_efficacy_from_conc(c = 1, x_inf = 0.1, x_0 = 1, ec50 = 0.5, h = 2)

}
\seealso{
predict_conc_from_efficacy
}
\keyword{fit_curves}
